/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.ResultSetValueSelector;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class JDBCStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> directSupportedTypes = new HashSet();
    private String driverClassName;
    private String connectionUrl;
    private String sqlQuery;
    private StreamComparator definedSort;
    private Connection connection;
    private Properties connectionProperties;
    private Statement statement;
    private ResultSetValueSelector[] valueSelectors;
    protected ResultSet resultSet;
    protected transient StreamContext streamContext;

    public JDBCStream(String connectionUrl, String sqlQuery, StreamComparator definedSort) throws IOException {
        this(connectionUrl, sqlQuery, definedSort, null, null);
    }

    public JDBCStream(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName) throws IOException {
        this.init(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClassName);
    }

    public JDBCStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter connectionUrlExpression = factory.getNamedOperand(expression, "connection");
        StreamExpressionNamedParameter sqlQueryExpression = factory.getNamedOperand(expression, "sql");
        StreamExpressionNamedParameter definedSortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter driverClassNameExpression = factory.getNamedOperand(expression, "driver");
        if (expression.getParameters().size() != namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        Properties connectionProperties = new Properties();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("driver") || namedParam.getName().equals("connection") || namedParam.getName().equals("sql") || namedParam.getName().equals("sort")) continue;
            connectionProperties.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String connectionUrl = null;
        if (null != connectionUrlExpression && connectionUrlExpression.getParameter() instanceof StreamExpressionValue) {
            connectionUrl = ((StreamExpressionValue)connectionUrlExpression.getParameter()).getValue();
        }
        if (null == connectionUrl) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - connection not found", connectionUrlExpression));
        }
        String sqlQuery = null;
        if (null != sqlQueryExpression && sqlQueryExpression.getParameter() instanceof StreamExpressionValue) {
            sqlQuery = ((StreamExpressionValue)sqlQueryExpression.getParameter()).getValue();
        }
        if (null == sqlQuery) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - sql not found", sqlQueryExpression));
        }
        StreamComparator definedSort = null;
        if (null != definedSortExpression && definedSortExpression.getParameter() instanceof StreamExpressionValue) {
            definedSort = factory.constructComparator(((StreamExpressionValue)definedSortExpression.getParameter()).getValue(), FieldComparator.class);
        }
        if (null == definedSort) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - sort not found", definedSortExpression));
        }
        String driverClass = null;
        if (null != driverClassNameExpression && driverClassNameExpression.getParameter() instanceof StreamExpressionValue) {
            driverClass = ((StreamExpressionValue)driverClassNameExpression.getParameter()).getValue();
        }
        this.init(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClass);
    }

    private void init(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName) {
        this.connectionUrl = connectionUrl;
        this.sqlQuery = sqlQuery;
        this.definedSort = definedSort;
        this.connectionProperties = connectionProperties;
        this.driverClassName = driverClassName;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        try {
            if (null != this.driverClassName) {
                Class.forName(this.driverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to load JDBC driver for '%s'", this.driverClassName), e);
        }
        try {
            if (null == DriverManager.getDriver(this.connectionUrl)) {
                throw new SQLException("DriverManager.getDriver(url) returned null");
            }
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to determine JDBC driver from connection url '%s'. Usually this means the driver is not loaded - you can have JDBCStream try to load it by providing the 'driverClassName' value", this.connectionUrl), e);
        }
        try {
            this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionProperties);
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to open JDBC connection to '%s'", this.connectionUrl), e);
        }
        try {
            this.statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to create a statement from JDBC connection '%s'", this.connectionUrl), e);
        }
        try {
            this.resultSet = this.statement.executeQuery(this.sqlQuery);
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to execute sqlQuery '%s' against JDBC connection '%s'", this.sqlQuery, this.connectionUrl), e);
        }
        try {
            this.valueSelectors = this.constructValueSelectors(this.resultSet.getMetaData());
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to generate value selectors for sqlQuery '%s' against JDBC connection '%s'", this.sqlQuery, this.connectionUrl), e);
        }
    }

    private ResultSetValueSelector[] constructValueSelectors(ResultSetMetaData metadata) throws SQLException {
        ResultSetValueSelector[] valueSelectors = new ResultSetValueSelector[metadata.getColumnCount()];
        for (int columnIdx = 0; columnIdx < metadata.getColumnCount(); ++columnIdx) {
            final int columnNumber = columnIdx + 1;
            final String columnName = metadata.getColumnLabel(columnNumber);
            String className = metadata.getColumnClassName(columnNumber);
            String typeName = metadata.getColumnTypeName(columnNumber);
            if (directSupportedTypes.contains(className)) {
                valueSelectors[columnIdx] = new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        Object obj = resultSet.getObject(columnNumber);
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        return obj;
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
                continue;
            }
            if (Short.class.getName().equals(className)) {
                valueSelectors[columnIdx] = new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        Short obj = resultSet.getShort(columnNumber);
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        return obj.longValue();
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
                continue;
            }
            if (Integer.class.getName().equals(className)) {
                valueSelectors[columnIdx] = new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        Integer obj = resultSet.getInt(columnNumber);
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        return obj.longValue();
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
                continue;
            }
            if (Float.class.getName().equals(className)) {
                valueSelectors[columnIdx] = new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        Float obj = Float.valueOf(resultSet.getFloat(columnNumber));
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        return obj.doubleValue();
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
                continue;
            }
            throw new SQLException(String.format(Locale.ROOT, "Unable to determine the valueSelector for column '%s' (col #%d) of java class '%s' and type '%s'", columnName, columnNumber, className, typeName));
        }
        return valueSelectors;
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.resultSet) {
                this.resultSet.close();
            }
            if (null != this.statement && !this.statement.isClosed()) {
                this.statement.close();
            }
            if (null != this.connection && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException("Failed to properly close JDBCStream", e);
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            if (this.resultSet.next()) {
                for (ResultSetValueSelector selector : this.valueSelectors) {
                    fields.put(selector.getColumnName(), selector.selectValue(this.resultSet));
                }
            } else {
                fields.put("EOF", true);
            }
            return new Tuple(fields);
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to read next record with error '%s'", e.getMessage()), e);
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("connection", this.connectionUrl));
        expression.addParameter(new StreamExpressionNamedParameter("sql", this.sqlQuery));
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.definedSort.toExpression(factory)));
        if (null != this.driverClassName) {
            expression.addParameter(new StreamExpressionNamedParameter("driver", this.driverClassName));
        }
        if (null != this.connectionProperties) {
            for (String propertyName : this.connectionProperties.stringPropertyNames()) {
                expression.addParameter(new StreamExpressionNamedParameter(propertyName, this.connectionProperties.getProperty(propertyName)));
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        StreamExpression expression = (StreamExpression)this.toExpression(factory);
        explanation.setExpression(expression.toString());
        String driverClassName = this.driverClassName;
        if (null == driverClassName) {
            try {
                driverClassName = DriverManager.getDriver(this.connectionUrl).getClass().getName();
            }
            catch (Exception e) {
                driverClassName = String.format(Locale.ROOT, "Failed to find driver for connectionUrl='%s'", this.connectionUrl);
            }
        }
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName("jdbc-source");
        child.setImplementingClass(driverClassName);
        child.setExpressionType("datastore");
        child.setExpression(this.sqlQuery);
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.definedSort;
    }

    static {
        directSupportedTypes.add(String.class.getName());
        directSupportedTypes.add(Double.class.getName());
        directSupportedTypes.add(Long.class.getName());
        directSupportedTypes.add(Boolean.class.getName());
    }
}

