/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.ModelCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ModelStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected String modelID;
    protected ModelCache modelCache;
    protected Tuple model;
    protected long cacheMillis;

    public ModelStream(String zkHost, String collectionName, String modelID, long cacheMillis) throws IOException {
        this.init(collectionName, zkHost, modelID, cacheMillis);
    }

    public ModelStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String modelID = (String)params.get("id");
        if (modelID == null) {
            throw new IOException("id param cannot be null for ModelStream");
        }
        long cacheMillis = 300000L;
        String cacheMillisParam = (String)params.get("cacheMillis");
        if (cacheMillisParam != null) {
            cacheMillis = Long.parseLong(cacheMillisParam);
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            zkHost = factory.getDefaultZkHost();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, zkHost, modelID, cacheMillis);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("id", this.modelID));
        expression.addParameter(new StreamExpressionNamedParameter("cacheMillis", Long.toString(this.cacheMillis)));
        return expression;
    }

    private void init(String collectionName, String zkHost, String modelID, long cacheMillis) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.modelID = modelID;
        this.cacheMillis = cacheMillis;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.modelCache = context.getModelCache();
    }

    @Override
    public void open() throws IOException {
        this.model = this.modelCache.getModel(this.collection, this.modelID, this.cacheMillis);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("ml-model");
        explanation.setExpression(this.toExpression(factory).toString());
        return explanation;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = null;
        if (this.model != null) {
            tuple = this.model;
            this.model = null;
        } else {
            tuple = Tuple.EOF();
        }
        return tuple;
    }
}

