/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import org.apache.solr.client.api.model.FileListResponse;
import org.apache.solr.client.api.model.IndexVersionResponse;
import org.apache.solr.client.api.util.CoreApiParameters;

@Path(value="/cores/{coreName}/replication")
public interface ReplicationApis {
    @GET
    @CoreApiParameters
    @Path(value="/indexversion")
    @Operation(summary="Return the index version of the specified core.", tags={"replication"})
    public IndexVersionResponse fetchIndexVersion() throws IOException;

    @GET
    @CoreApiParameters
    @Path(value="/files")
    @Operation(summary="Return the list of index file that make up the specified core.", tags={"replication"})
    public FileListResponse fetchFileList(@Parameter(description="The generation number of the index", required=true) @QueryParam(value="generation") long var1);

    @GET
    @CoreApiParameters
    @Operation(summary="Get a stream of a specific file path of a core", tags={"core-replication"}, extensions={@Extension(properties={@ExtensionProperty(name="omitFromCodegen", value="true")})})
    @Path(value="/files/{filePath}")
    public StreamingOutput fetchFile(@PathParam(value="filePath") String var1, @Parameter(description="Directory type for specific filePath (cf or tlogFile). Defaults to Lucene index (file) directory if empty", required=true) @QueryParam(value="dirType") String var2, @Parameter(description="Output stream read/write offset", required=false) @QueryParam(value="offset") String var3, @Parameter(required=false) @QueryParam(value="len") String var4, @Parameter(description="Compress file output", required=false) @QueryParam(value="compression") @DefaultValue(value="false") Boolean var5, @Parameter(description="Write checksum with output stream", required=false) @QueryParam(value="checksum") @DefaultValue(value="false") Boolean var6, @Parameter(description="Limit data write per seconds. Defaults to no throttling", required=false) @QueryParam(value="maxWriteMBPerSec") double var7, @Parameter(description="The generation number of the index", required=false) @QueryParam(value="generation") Long var9);
}

