/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.osgi;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebconsoleClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RequestExecutor executor;
    private final RequestBuilder builder;
    private final String username;
    private final String password;

    public WebconsoleClient(String slingServerUrl, String username, String password) {
        this.builder = new RequestBuilder(slingServerUrl);
        this.executor = new RequestExecutor(new DefaultHttpClient());
        this.username = username;
        this.password = password;
    }

    public void installBundle(File f, boolean startBundle) throws Exception {
        this.log.info("Installing additional bundle {}", (Object)f.getName());
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("action", (ContentBody)new StringBody("install"));
        if (startBundle) {
            entity.addPart("bundlestart", (ContentBody)new StringBody("true"));
        }
        entity.addPart("bundlefile", (ContentBody)new FileBody(f));
        this.executor.execute(this.builder.buildPostRequest("/system/console/bundles").withCredentials(this.username, this.password).withEntity((HttpEntity)entity)).assertStatus(302);
    }
}

