/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

final class ModelAdapterFactoryUtil {
    private ModelAdapterFactoryUtil() {
    }

    public static void addModelsForPackage(String packageName, BundleContext bundleContext) {
        ModelsPackageBundle bundle = new ModelsPackageBundle(packageName, 32, bundleContext);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)bundleContext, (BundleEvent)event);
    }

    private static class ModelsPackageBundle
    implements Bundle {
        private final String packageName;
        private final int state;
        private final BundleContext bundleContext;

        public ModelsPackageBundle(String packageName, int state, BundleContext bundleContext) {
            this.packageName = packageName;
            this.state = state;
            this.bundleContext = bundleContext;
        }

        public int getState() {
            return this.state;
        }

        public Dictionary getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("Sling-Model-Packages", this.packageName);
            return headers;
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            Reflections reflections = new Reflections(this.packageName, new Scanner[0]);
            Set types = reflections.getTypesAnnotatedWith(Model.class);
            Vector<URL> urls = new Vector<URL>();
            try {
                for (Class type : types) {
                    urls.add(new URL("file:/" + type.getName().replace('.', '/') + ".class"));
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Malformed URL.", ex);
            }
            return urls.elements();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.getClass().getClassLoader().loadClass(name);
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference[] getRegisteredServices() {
            return null;
        }

        public ServiceReference[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Enumeration getResources(String name) throws IOException {
            return null;
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Map getSignerCertificates(int signersType) {
            return null;
        }

        public Version getVersion() {
            return null;
        }
    }
}

