/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockResourceResolverFactoryActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

class MockJcrResourceResolverFactory
implements ResourceResolverFactory {
    private final SlingRepository slingRepository;
    private final BundleContext bundleContext;

    public MockJcrResourceResolverFactory(SlingRepository repository, BundleContext bundleContext) {
        this.slingRepository = repository;
        this.bundleContext = bundleContext;
    }

    private ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        Hashtable<String, Object> resourceProviderFactoryFactoryProps = new Hashtable<String, Object>();
        ((Dictionary)resourceProviderFactoryFactoryProps).put("service.vendor", "sling-mock");
        ((Dictionary)resourceProviderFactoryFactoryProps).put("service.description", "sling-mock");
        ((Dictionary)resourceProviderFactoryFactoryProps).put("resource.resolver.manglenamespaces", true);
        ((Dictionary)resourceProviderFactoryFactoryProps).put("resource.resolver.searchpath", new String[]{"/apps", "/libs"});
        ComponentContext resourceProviderComponentContext = MockOsgi.newComponentContext((BundleContext)this.bundleContext, resourceProviderFactoryFactoryProps);
        if (this.bundleContext.getServiceReference(SlingRepository.class.getName()) == null) {
            this.bundleContext.registerService(SlingRepository.class.getName(), (Object)this.slingRepository, null);
        }
        JcrResourceProviderFactory jcrResourceProviderFactory = new JcrResourceProviderFactory();
        MockOsgi.injectServices((Object)jcrResourceProviderFactory, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)jcrResourceProviderFactory, (BundleContext)this.bundleContext, (Map)ImmutableMap.of());
        ResourceProvider resourceProvider = isAdmin ? jcrResourceProviderFactory.getAdministrativeResourceProvider(authenticationInfo) : jcrResourceProviderFactory.getResourceProvider(authenticationInfo);
        Hashtable<Object, Object> resourceProviderProps = new Hashtable<Object, Object>();
        ((Dictionary)resourceProviderProps).put("provider.roots", new String[]{"/"});
        MockResourceResolverFactoryActivator activator = new MockResourceResolverFactoryActivator();
        activator.bindResourceProvider(resourceProvider, MockJcrResourceResolverFactory.toMap(resourceProviderProps));
        activator.activate(resourceProviderComponentContext);
        CommonResourceResolverFactoryImpl commonFactoryImpl = new CommonResourceResolverFactoryImpl((ResourceResolverFactoryActivator)activator);
        ResourceResolverContext context = new ResourceResolverContext(true, authenticationInfo, new ResourceAccessSecurityTracker());
        ResourceResolverImpl resourceResolver = new ResourceResolverImpl(commonFactoryImpl, context);
        return resourceResolver;
    }

    private static Map<String, Object> toMap(Dictionary<Object, Object> dictionary) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<Object> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, false);
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getThreadResourceResolver() {
        throw new UnsupportedOperationException();
    }
}

