/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Component(inherit=false)
@Service(value={AdapterFactory.class})
public final class MockModelAdapterFactory
extends ModelAdapterFactory {
    private final BundleContext bundleContext;

    public MockModelAdapterFactory(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.bundleContext.addServiceListener((ServiceListener)new InjectorServiceListener());
        this.activate(componentContext);
    }

    public MockModelAdapterFactory() {
        this(MockOsgi.newComponentContext());
    }

    public void addModelsForPackage(String packageName) {
        ModelsPackageBundle bundle = new ModelsPackageBundle(packageName, 32);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)this.bundleContext, (BundleEvent)event);
    }

    private class ModelsPackageBundle
    implements Bundle {
        private final String packageName;
        private final int state;

        public ModelsPackageBundle(String packageName, int state) {
            this.packageName = packageName;
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public Dictionary getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("Sling-Model-Packages", this.packageName);
            return headers;
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            Reflections reflections = new Reflections(this.packageName, new Scanner[0]);
            Set types = reflections.getTypesAnnotatedWith(Model.class);
            Vector<URL> urls = new Vector<URL>();
            try {
                for (Class type : types) {
                    urls.add(new URL("file:/" + type.getName().replace('.', '/') + ".class"));
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Malformed URL.", ex);
            }
            return urls.elements();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.getClass().getClassLoader().loadClass(name);
        }

        public BundleContext getBundleContext() {
            return MockModelAdapterFactory.this.bundleContext;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference[] getRegisteredServices() {
            return null;
        }

        public ServiceReference[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Enumeration getResources(String name) throws IOException {
            return null;
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Map getSignerCertificates(int signersType) {
            return null;
        }

        public Version getVersion() {
            return null;
        }
    }

    private class InjectorServiceListener
    implements ServiceListener {
        private InjectorServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            Object service = MockModelAdapterFactory.this.bundleContext.getService(event.getServiceReference());
            if (service instanceof Injector) {
                if (event.getType() == 1) {
                    MockModelAdapterFactory.this.bindInjector((Injector)service, this.getServiceProperties(event.getServiceReference()));
                } else if (event.getType() == 4) {
                    MockModelAdapterFactory.this.unbindInjector((Injector)service, this.getServiceProperties(event.getServiceReference()));
                }
            }
            if (service instanceof InjectAnnotationProcessorFactory) {
                if (event.getType() == 1) {
                    MockModelAdapterFactory.this.bindInjectAnnotationProcessorFactory((InjectAnnotationProcessorFactory)service, this.getServiceProperties(event.getServiceReference()));
                } else if (event.getType() == 4) {
                    MockModelAdapterFactory.this.unbindInjectAnnotationProcessorFactory((InjectAnnotationProcessorFactory)service, this.getServiceProperties(event.getServiceReference()));
                }
            }
            if (service instanceof ImplementationPicker) {
                if (event.getType() == 1) {
                    MockModelAdapterFactory.this.bindImplementationPicker((ImplementationPicker)service, this.getServiceProperties(event.getServiceReference()));
                } else if (event.getType() == 4) {
                    MockModelAdapterFactory.this.unbindImplementationPicker((ImplementationPicker)service, this.getServiceProperties(event.getServiceReference()));
                }
            }
        }

        private Map<String, Object> getServiceProperties(ServiceReference reference) {
            String[] propertyKeys;
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String key : propertyKeys = reference.getPropertyKeys()) {
                props.put(key, reference.getProperty(key));
            }
            return props;
        }
    }
}

