/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.impl.FirstImplementationPicker;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ResourcePathInjector;
import org.apache.sling.models.impl.injectors.ResourceResolverInjector;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ContentBuilder;
import org.apache.sling.testing.mock.sling.context.ContextResourceResolverFactory;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.apache.sling.testing.mock.sling.services.MockMimeTypeService;
import org.apache.sling.testing.mock.sling.services.MockModelAdapterFactory;
import org.apache.sling.testing.mock.sling.services.MockSlingSettingService;
import org.apache.sling.testing.mock.sling.servlet.MockRequestPathInfo;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class SlingContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();
    protected ResourceResolverFactory resourceResolverFactory;
    protected MockModelAdapterFactory modelAdapterFactory;
    protected ResourceResolverType resourceResolverType;
    protected ComponentContext componentContext;
    protected ResourceResolver resourceResolver;
    protected MockSlingHttpServletRequest request;
    protected MockSlingHttpServletResponse response;
    protected SlingScriptHelper slingScriptHelper;
    protected ContentLoader contentLoader;
    protected ContentBuilder contentBuilder;

    protected void setResourceResolverType(ResourceResolverType resourceResolverType) {
        this.resourceResolverType = resourceResolverType;
    }

    protected void setUp() {
        MockSling.setAdapterManagerBundleContext(this.bundleContext());
        this.resourceResolverFactory = this.newResourceResolverFactory();
        this.registerDefaultServices();
    }

    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType);
    }

    protected void registerDefaultServices() {
        this.registerService(ResourceResolverFactory.class, this.resourceResolverFactory);
        this.modelAdapterFactory = new MockModelAdapterFactory(this.componentContext());
        this.registerService(AdapterFactory.class, this.modelAdapterFactory);
        this.registerService(Injector.class, new BindingsInjector());
        this.registerService(Injector.class, new ChildResourceInjector());
        OSGiServiceInjector osgiServiceInjector = new OSGiServiceInjector();
        osgiServiceInjector.activate(this.componentContext());
        this.registerService(Injector.class, osgiServiceInjector);
        this.registerService(Injector.class, new RequestAttributeInjector());
        this.registerService(Injector.class, new ResourcePathInjector());
        this.registerService(Injector.class, new ResourceResolverInjector());
        this.registerService(Injector.class, new SelfInjector());
        this.registerService(Injector.class, new SlingObjectInjector());
        this.registerService(Injector.class, new ValueMapInjector());
        this.registerService(ImplementationPicker.class, new FirstImplementationPicker());
        this.registerService(SlingSettingsService.class, new MockSlingSettingService(DEFAULT_RUN_MODES));
        this.registerService(MimeTypeService.class, new MockMimeTypeService());
    }

    protected void tearDown() {
        if (this.resourceResolver != null) {
            this.resourceResolver.revert();
            Session session = (Session)this.resourceResolver.adaptTo(Session.class);
            if (session != null) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        this.modelAdapterFactory = null;
        this.componentContext = null;
        this.resourceResolver = null;
        this.request = null;
        this.response = null;
        this.slingScriptHelper = null;
        this.contentLoader = null;
        this.contentBuilder = null;
        MockSling.clearAdapterManagerBundleContext();
    }

    public final ResourceResolverType resourceResolverType() {
        return this.resourceResolverType;
    }

    public final ComponentContext componentContext() {
        if (this.componentContext == null) {
            this.componentContext = MockOsgi.newComponentContext();
        }
        return this.componentContext;
    }

    public final BundleContext bundleContext() {
        return this.componentContext().getBundleContext();
    }

    public final ResourceResolver resourceResolver() {
        if (this.resourceResolver == null) {
            try {
                this.resourceResolver = this.resourceResolverFactory.getResourceResolver(null);
            }
            catch (LoginException ex) {
                throw new RuntimeException("Creating resource resolver failed.", ex);
            }
        }
        return this.resourceResolver;
    }

    public final MockSlingHttpServletRequest request() {
        if (this.request == null) {
            this.request = new MockSlingHttpServletRequest(this.resourceResolver());
            SlingBindings bindings = new SlingBindings();
            bindings.put((Object)"request", (Object)this.request);
            bindings.put((Object)"response", (Object)this.response());
            bindings.put((Object)"sling", (Object)this.slingScriptHelper());
            this.request.setAttribute(SlingBindings.class.getName(), bindings);
        }
        return this.request;
    }

    public final MockRequestPathInfo requestPathInfo() {
        return (MockRequestPathInfo)this.request().getRequestPathInfo();
    }

    public final MockSlingHttpServletResponse response() {
        if (this.response == null) {
            this.response = new MockSlingHttpServletResponse();
        }
        return this.response;
    }

    public final SlingScriptHelper slingScriptHelper() {
        if (this.slingScriptHelper == null) {
            this.slingScriptHelper = MockSling.newSlingScriptHelper(this.request(), this.response(), this.bundleContext());
        }
        return this.slingScriptHelper;
    }

    public ContentLoader load() {
        if (this.contentLoader == null) {
            this.contentLoader = new ContentLoader(this.resourceResolver(), this.bundleContext());
        }
        return this.contentLoader;
    }

    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this.resourceResolver());
        }
        return this.contentBuilder;
    }

    public final <T> T registerService(T service) {
        return this.registerService(null, service, null);
    }

    public final <T> T registerService(Class<T> serviceClass, T service) {
        return this.registerService(serviceClass, service, null);
    }

    public final <T> T registerService(Class<T> serviceClass, T service, Map<String, Object> properties) {
        Hashtable<String, Object> serviceProperties = null;
        if (properties != null) {
            serviceProperties = new Hashtable<String, Object>(properties);
        }
        this.bundleContext().registerService(serviceClass != null ? serviceClass.getName() : null, service, serviceProperties);
        return service;
    }

    public final <T> T registerInjectActivateService(T service) {
        return this.registerInjectActivateService(service, (Map<String, Object>)ImmutableMap.of());
    }

    public final <T> T registerInjectActivateService(T service, Map<String, Object> properties) {
        MockOsgi.injectServices(service, (BundleContext)this.bundleContext());
        MockOsgi.activate(service, (BundleContext)this.bundleContext(), properties);
        this.registerService(null, service, null);
        return service;
    }

    public final <ServiceType> ServiceType getService(Class<ServiceType> serviceType) {
        return (ServiceType)this.slingScriptHelper().getService(serviceType);
    }

    public final <ServiceType> ServiceType[] getServices(Class<ServiceType> serviceType, String filter) {
        return this.slingScriptHelper().getServices(serviceType, filter);
    }

    public final Resource currentResource() {
        return this.request().getResource();
    }

    public final Resource currentResource(String resourcePath) {
        if (resourcePath != null) {
            Resource resource = this.resourceResolver().getResource(resourcePath);
            if (resource == null) {
                throw new IllegalArgumentException("Resource does not exist: " + resourcePath);
            }
            return this.currentResource(resource);
        }
        return this.currentResource((Resource)null);
    }

    public final Resource currentResource(Resource resource) {
        this.request().setResource(resource);
        return resource;
    }

    public final void addModelsForPackage(String packageName) {
        this.modelAdapterFactory.addModelsForPackage(packageName);
    }

    public final void runMode(String ... runModes) {
        ImmutableSet newRunModes = ImmutableSet.builder().add((Object[])runModes).build();
        ServiceReference ref = this.bundleContext().getServiceReference(SlingSettingsService.class.getName());
        if (ref != null) {
            MockSlingSettingService slingSettings = (MockSlingSettingService)this.bundleContext().getService(ref);
            slingSettings.setRunModes((Set<String>)newRunModes);
        }
    }
}

