/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockResourceResolverFactoryActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

class MockJcrResourceResolverFactory
implements ResourceResolverFactory {
    private final SlingRepository slingRepository;

    public MockJcrResourceResolverFactory(SlingRepository repository) {
        this.slingRepository = repository;
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        Hashtable<String, Object> resourceProviderFactoryProps = new Hashtable<String, Object>();
        ((Dictionary)resourceProviderFactoryProps).put("service.vendor", "sling-mock");
        ((Dictionary)resourceProviderFactoryProps).put("service.description", "sling-mock");
        ((Dictionary)resourceProviderFactoryProps).put("resource.resolver.manglenamespaces", true);
        ComponentContext componentContext = MockOsgi.newComponentContext(resourceProviderFactoryProps);
        componentContext.getBundleContext().registerService(SlingRepository.class.getName(), (Object)this.slingRepository, null);
        JcrResourceProviderFactory jcrResourceProviderFactory = new JcrResourceProviderFactory();
        MockOsgi.injectServices((Object)jcrResourceProviderFactory, (BundleContext)componentContext.getBundleContext());
        MockOsgi.activate((Object)jcrResourceProviderFactory, (BundleContext)componentContext.getBundleContext(), (Map)ImmutableMap.of());
        ResourceProvider resourceProvider = jcrResourceProviderFactory.getAdministrativeResourceProvider(new HashMap());
        Hashtable<String, String[]> resourceProviderProps = new Hashtable<String, String[]>();
        ((Dictionary)resourceProviderProps).put("provider.roots", new String[]{"/"});
        componentContext.getBundleContext().registerService(ResourceProvider.class.getName(), (Object)resourceProvider, resourceProviderProps);
        ServiceReference resourceProviderServiceReference = componentContext.getBundleContext().getServiceReference(ResourceProvider.class.getName());
        MockResourceResolverFactoryActivator activator = new MockResourceResolverFactoryActivator();
        activator.bindResourceProvider(resourceProvider, this.getServiceReferenceProperties(resourceProviderServiceReference));
        activator.activate(componentContext);
        CommonResourceResolverFactoryImpl commonFactoryImpl = new CommonResourceResolverFactoryImpl((ResourceResolverFactoryActivator)activator);
        ResourceResolverContext context = new ResourceResolverContext(true, null, new ResourceAccessSecurityTracker());
        ResourceResolverImpl resourceResolver = new ResourceResolverImpl(commonFactoryImpl, context);
        return resourceResolver;
    }

    private Map<String, Object> getServiceReferenceProperties(ServiceReference serviceReference) {
        String[] keys;
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : keys = serviceReference.getPropertyKeys()) {
            props.put(key, serviceReference.getProperty(key));
        }
        return props;
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolver(authenticationInfo);
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolver(authenticationInfo);
    }
}

