/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.settings.impl.RunModeCommand;
import org.apache.sling.settings.impl.SettingsServiceConfigurator;
import org.apache.sling.settings.impl.SlingPropertiesPrinter;
import org.apache.sling.settings.impl.SlingSettingsPrinter;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServicesListener {
    private final BundleContext bundleContext;
    private final Listener startupListener;
    private ConfigAdminListener configAdminListener;
    private ShellListener shellListener;
    private ServiceRegistration settingsReg;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.startupListener = new Listener(StartupHandler.class.getName());
        this.startupListener.start();
    }

    public synchronized void notifyChange() {
        StartupHandler handler = (StartupHandler)this.startupListener.getService();
        if (handler != null && this.settingsReg == null) {
            this.activate(handler);
        }
    }

    private void activate(StartupHandler handler) {
        SlingSettingsServiceImpl settingsService = new SlingSettingsServiceImpl(this.bundleContext, handler);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Settings Service");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.settingsReg = this.bundleContext.registerService(new String[]{SlingSettingsService.class.getName()}, (Object)settingsService, props);
        SlingPropertiesPrinter.initPlugin(this.bundleContext);
        SlingSettingsPrinter.initPlugin(this.bundleContext, settingsService);
        this.configAdminListener = new ConfigAdminListener(settingsService);
        this.configAdminListener.start();
        this.shellListener = new ShellListener(settingsService);
        this.shellListener.start();
    }

    public void deactivate() {
        if (this.shellListener != null) {
            this.shellListener.deactivate();
            this.shellListener = null;
        }
        if (this.configAdminListener != null) {
            this.configAdminListener.deactivate();
            this.configAdminListener = null;
        }
        this.startupListener.deactivate();
        if (this.settingsReg != null) {
            this.settingsReg.unregister();
            this.settingsReg = null;
        }
        SlingSettingsPrinter.destroyPlugin();
        SlingPropertiesPrinter.destroyPlugin();
    }

    private final class ShellListener
    extends AbstractListener {
        private Object runModeCommand;
        private final SlingSettingsServiceImpl settings;

        public ShellListener(SlingSettingsServiceImpl settings) {
            super("org.apache.felix.shell.ShellService");
            this.settings = settings;
        }

        protected void serviceChanged() {
            if (this.getService() != null && this.runModeCommand == null) {
                this.runModeCommand = new RunModeCommand(ServicesListener.this.bundleContext, this.settings.getRunModes());
            }
        }

        public void deactivate() {
            super.deactivate();
            if (this.runModeCommand != null) {
                ((RunModeCommand)this.runModeCommand).destroy();
                this.runModeCommand = null;
            }
        }
    }

    private final class ConfigAdminListener
    extends AbstractListener {
        private Object settingsServiceConfigurator;
        private final SlingSettingsServiceImpl settings;

        public ConfigAdminListener(SlingSettingsServiceImpl settings) {
            super("org.osgi.service.cm.ConfigurationAdmin");
            this.settings = settings;
        }

        protected void serviceChanged() {
            if (this.getService() != null && this.settingsServiceConfigurator == null) {
                this.settingsServiceConfigurator = new SettingsServiceConfigurator(ServicesListener.this.bundleContext, this.settings);
            }
        }

        public void deactivate() {
            super.deactivate();
            if (this.settingsServiceConfigurator != null) {
                ((SettingsServiceConfigurator)this.settingsServiceConfigurator).destroy();
                this.settingsServiceConfigurator = null;
            }
        }
    }

    private final class Listener
    extends AbstractListener {
        public Listener(String serviceName) {
            super(serviceName);
        }

        protected void serviceChanged() {
            ServicesListener.this.notifyChange();
        }
    }

    private abstract class AbstractListener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference reference;
        private volatile Object service;

        public AbstractListener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            this.retainService();
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        this.serviceChanged();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                this.serviceChanged();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService();
            }
        }

        protected abstract void serviceChanged();
    }
}

