/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.shell.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunModeCommand
implements Command {
    private static final String CMD_NAME = "runmodes";
    private final ServiceRegistration pluginReg;
    private final Set<String> modes;

    public RunModeCommand(BundleContext btx, Set<String> modes) {
        this.modes = modes;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Sling Run Mode Shell Command");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.pluginReg = btx.registerService(Command.class.getName(), (Object)this, props);
    }

    public void destroy() {
        this.pluginReg.unregister();
    }

    public String getName() {
        return CMD_NAME;
    }

    public String getShortDescription() {
        return "lists current run modes";
    }

    public String getUsage() {
        return CMD_NAME;
    }

    public void execute(String command, PrintStream out, PrintStream err) {
        out.print("Current Run Modes: ");
        if (this.modes == null || this.modes.size() == 0) {
            out.println("-");
        } else {
            out.println(this.modes);
        }
    }
}

