/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingSettingsServiceImpl
implements SlingSettingsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String slingId;
    private String slingHome;
    private URL slingHomeUrl;
    private Set<String> runModes;
    private static final String DATA_FILE = "sling.id.file";
    private static final String OPTIONS_FILE = "sling.options.file";

    public SlingSettingsServiceImpl(BundleContext context) {
        this.setupSlingHome(context);
        boolean isInstall = this.setupSlingId(context);
        this.setupRunModes(context, isInstall);
    }

    private void setupSlingHome(BundleContext context) {
        this.slingHome = context.getProperty("sling.home");
        String url = context.getProperty("sling.home.url");
        if (url != null) {
            try {
                this.slingHomeUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.logger.error("Sling home url is not a url: {}", (Object)url);
            }
        }
    }

    private boolean setupSlingId(BundleContext context) {
        File idFile = context.getDataFile(DATA_FILE);
        if (idFile == null) {
            throw new RuntimeException("Unable to read from bundle data file.");
        }
        this.slingId = this.readSlingId(idFile);
        if (this.slingId == null) {
            this.slingId = UUID.randomUUID().toString();
            this.writeSlingId(idFile, this.slingId);
            return true;
        }
        return false;
    }

    private List<Options> handleOptions(Set<String> modesSet, String propOptions) {
        if (propOptions != null && propOptions.trim().length() > 0) {
            String[] options;
            ArrayList<Options> optionsList = new ArrayList<Options>();
            for (String opt : options = propOptions.trim().split("\\|")) {
                String selected = null;
                String[] modes = opt.trim().split(",");
                for (int i = 0; i < modes.length; ++i) {
                    modes[i] = modes[i].trim();
                    if (selected != null) {
                        modesSet.remove(modes[i]);
                        continue;
                    }
                    if (!modesSet.contains(modes[i])) continue;
                    selected = modes[i];
                }
                if (selected == null) {
                    selected = modes[0];
                    modesSet.add(modes[0]);
                }
                Options o = new Options();
                o.selected = selected;
                o.modes = modes;
                optionsList.add(o);
            }
            return optionsList;
        }
        return null;
    }

    private void setupRunModes(BundleContext context, boolean isInstall) {
        HashSet<String> modesSet = new HashSet<String>();
        String prop = context.getProperty("sling.run.modes");
        if (prop != null && prop.trim().length() > 0) {
            String[] modes = prop.split(",");
            for (int i = 0; i < modes.length; ++i) {
                modesSet.add(modes[i].trim());
            }
        }
        this.handleOptions(modesSet, context.getProperty("sling.run.mode.options"));
        if (isInstall) {
            List<Options> optionsList = this.handleOptions(modesSet, context.getProperty("sling.run.mode.install.options"));
            if (optionsList != null) {
                File file = context.getDataFile(OPTIONS_FILE);
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    fos = new FileOutputStream(file);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(optionsList);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to write to options data file.", ioe);
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        } else {
            File file = context.getDataFile(OPTIONS_FILE);
            if (file.exists()) {
                List optionsList = null;
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                try {
                    fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    optionsList = (List)ois.readObject();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to read from options data file.", ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Unable to read from options data file.", cnfe);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                if (optionsList != null) {
                    for (Options o : optionsList) {
                        for (String m : o.modes) {
                            modesSet.remove(m);
                        }
                        modesSet.add(o.selected);
                    }
                }
            }
        }
        this.runModes = Collections.synchronizedSet(Collections.unmodifiableSet(modesSet));
        if (this.runModes.size() > 0) {
            this.logger.info("Active run modes: {}", this.runModes);
        } else {
            this.logger.info("No run modes active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSlingId(File idFile) {
        if (idFile.exists() && idFile.length() >= 36L) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(idFile);
                byte[] rawBytes = new byte[36];
                if (fin.read(rawBytes) == 36) {
                    String rawString = new String(rawBytes, "ISO-8859-1");
                    String id = UUID.fromString(rawString).toString();
                    this.logger.debug("Got Sling ID {} from file {}", (Object)id, (Object)idFile);
                    String string = id;
                    return string;
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed reading UUID from id file " + idFile + ", creating new id", t);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSlingId(File idFile, String id) {
        idFile.delete();
        idFile.getParentFile().mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(idFile);
            fout.write(this.slingId.getBytes("ISO-8859-1"));
            fout.flush();
        }
        catch (Throwable t) {
            this.logger.error("Failed writing UUID to id file " + idFile, t);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public String getAbsolutePathWithinSlingHome(String relativePath) {
        return new File(this.slingHome, relativePath).getAbsolutePath();
    }

    @Override
    public String getSlingId() {
        return this.slingId;
    }

    @Override
    public URL getSlingHome() {
        return this.slingHomeUrl;
    }

    @Override
    public String getSlingHomePath() {
        return this.slingHome;
    }

    @Override
    public Set<String> getRunModes() {
        return this.runModes;
    }

    private static final class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String[] modes;
        String selected;

        private Options() {
        }
    }
}

