/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingSettingsServiceImpl
implements SlingSettingsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String slingId;
    private String slingHome;
    private URL slingHomeUrl;
    private Set<String> runModes;
    private static final String DATA_FILE = "sling.id.file";

    public SlingSettingsServiceImpl(BundleContext context) {
        this.setupSlingHome(context);
        this.setupSlingId(context);
        this.setupRunModes(context);
    }

    private void setupSlingHome(BundleContext context) {
        this.slingHome = context.getProperty("sling.home");
        String url = context.getProperty("sling.home.url");
        if (url != null) {
            try {
                this.slingHomeUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.logger.error("Sling home url is not a url: {}", (Object)url);
            }
        }
    }

    private void setupSlingId(BundleContext context) {
        File idFile = context.getDataFile(DATA_FILE);
        if (idFile == null) {
            throw new RuntimeException("Unable to read from bundle data file.");
        }
        this.slingId = this.readSlingId(idFile);
        if (this.slingId == null) {
            this.slingId = UUID.randomUUID().toString();
            this.writeSlingId(idFile, this.slingId);
        }
    }

    private void setupRunModes(BundleContext context) {
        String prop = context.getProperty("sling.run.modes");
        if (prop == null || prop.trim().length() == 0) {
            this.runModes = Collections.emptySet();
        } else {
            HashSet<String> modesSet = new HashSet<String>();
            String[] modes = prop.split(",");
            for (int i = 0; i < modes.length; ++i) {
                modesSet.add(modes[i].trim());
            }
            this.runModes = Collections.synchronizedSet(Collections.unmodifiableSet(modesSet));
            this.logger.info("Active run modes {}", this.runModes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSlingId(File idFile) {
        if (idFile.exists() && idFile.length() >= 36L) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(idFile);
                byte[] rawBytes = new byte[36];
                if (fin.read(rawBytes) == 36) {
                    String rawString = new String(rawBytes, "ISO-8859-1");
                    String id = UUID.fromString(rawString).toString();
                    this.logger.debug("Got Sling ID {} from file {}", (Object)id, (Object)idFile);
                    String string = id;
                    return string;
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed reading UUID from id file " + idFile + ", creating new id", t);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSlingId(File idFile, String id) {
        idFile.delete();
        idFile.getParentFile().mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(idFile);
            fout.write(this.slingId.getBytes("ISO-8859-1"));
            fout.flush();
        }
        catch (Throwable t) {
            this.logger.error("Failed writing UUID to id file " + idFile, t);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public String getAbsolutePathWithinSlingHome(String relativePath) {
        return new File(this.slingHome, relativePath).getAbsolutePath();
    }

    @Override
    public String getSlingId() {
        return this.slingId;
    }

    @Override
    public URL getSlingHome() {
        return this.slingHomeUrl;
    }

    @Override
    public String getSlingHomePath() {
        return this.slingHome;
    }

    @Override
    public Set<String> getRunModes() {
        return this.runModes;
    }
}

