/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jst;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.jcr.RepositoryException;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.jst.HtmlCodeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JstScriptEngine
extends AbstractSlingScriptEngine {
    private final HtmlCodeGenerator htmlGenerator;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    JstScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        super(scriptEngineFactory);
        this.htmlGenerator = new HtmlCodeGenerator();
    }

    public Object eval(Reader script, ScriptContext context) throws ScriptException {
        Bindings props = context.getBindings(100);
        SlingScriptHelper helper = (SlingScriptHelper)props.get("sling");
        InputStream scriptStream = (InputStream)helper.getScript().getScriptResource().adaptTo(InputStream.class);
        try {
            this.htmlGenerator.generateHtml(helper.getRequest(), helper.getScript().getScriptResource().getPath(), scriptStream, helper.getResponse().getWriter());
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
        catch (RepositoryException re) {
            throw new ScriptException((Exception)((Object)re));
        }
        catch (JSONException je) {
            throw new ScriptException((Exception)((Object)je));
        }
        finally {
            if (scriptStream != null) {
                try {
                    scriptStream.close();
                }
                catch (IOException ioe) {
                    this.log.warn("IOException while closing scriptStream", (Throwable)ioe);
                }
            }
        }
        return null;
    }
}

