/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jst;

import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;

public class HtmlContentRenderer {
    public static final String BREADCRUMB_PREFIX = "/content";

    public void render(PrintWriter pw, Resource r, Node n, String title) throws RepositoryException {
        pw.print("<h1 class='title'>");
        pw.print(this.escape(title));
        pw.println("</h1>");
        this.renderBreadcrumbs(pw, n);
        this.renderChildNodes(pw, n);
        PropertyIterator pi = n.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (!this.displayProperty(p.getName())) continue;
            this.renderPropertyValue(pw, p);
        }
    }

    protected void renderBreadcrumbs(PrintWriter pw, Node n) throws RepositoryException {
        String path = n.getPath();
        pw.println("<div class='breadcrumbs'>");
        if (path.startsWith(BREADCRUMB_PREFIX)) {
            String[] crumbs = path.substring(BREADCRUMB_PREFIX.length() + 1).split("/");
            for (int i = 0; i < crumbs.length - 1; ++i) {
                String c = crumbs[i];
                pw.print("<a href='");
                pw.print(this.getDotDots(i, crumbs.length));
                pw.print(c);
                pw.print("'>");
                pw.print(c);
                pw.println("</a>");
            }
        }
        pw.println("</div>");
    }

    protected String getDotDots(int start, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < len - 1; ++i) {
            sb.append("../");
        }
        return sb.toString();
    }

    protected void renderChildNodes(PrintWriter pw, Node parent) throws RepositoryException {
        pw.println("<div class='childnodes'>");
        String prefix = parent.getName() + "/";
        NodeIterator it = parent.getNodes();
        while (it.hasNext()) {
            Node kid = it.nextNode();
            pw.print("<a href='");
            pw.print(prefix);
            pw.print(kid.getName());
            pw.print("'>");
            pw.print(kid.getName());
            pw.println("</a>");
        }
        pw.println("</div>");
    }

    protected void renderPropertyValue(PrintWriter pw, Property p) throws RepositoryException {
        pw.print("<div class='" + p.getName() + "'>");
        if (p.getDefinition().isMultiple()) {
            Value[] values = p.getValues();
            pw.print('[');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.escape(values[i].getString()));
            }
            pw.print(']');
        } else {
            pw.print(this.escape(p.getValue().getString()));
        }
        pw.println("</div>");
    }

    protected String escape(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected boolean displayProperty(String name) {
        return !name.startsWith("jcr:") && !name.startsWith("sling:");
    }
}

