/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.jcr.api.SlingRepository;

@Component
@Service(value={ConfigurationPrinter.class})
@Properties(value={@Property(name="service.description", value={"JCR Descriptors Configuration Printer"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class DescriptorsConfigurationPrinter
implements ConfigurationPrinter {
    @Reference(policy=ReferencePolicy.DYNAMIC)
    private volatile SlingRepository slingRepository;

    public String getTitle() {
        return "JCR Descriptors";
    }

    public void printConfiguration(PrintWriter pw) {
        if (this.slingRepository != null) {
            String[] descriptorKeys;
            for (String key : descriptorKeys = this.slingRepository.getDescriptorKeys()) {
                pw.printf("%s = %s\n", key, this.slingRepository.getDescriptor(key));
            }
        } else {
            pw.println("SlingRepository is not available.");
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

