/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.felix.webconsole.ModeAwareConfigurationPrinter;
import org.apache.sling.jcr.api.SlingRepository;

public class NodeTypeConfigurationPrinter
implements ModeAwareConfigurationPrinter {
    private SlingRepository slingRepository;

    public String getTitle() {
        return "JCR NodeTypes";
    }

    public void printConfiguration(PrintWriter pw, String mode) {
        if (this.slingRepository != null) {
            try {
                Session session = this.slingRepository.loginAdministrative(null);
                NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
                NodeTypeIterator it = ntm.getAllNodeTypes();
                while (it.hasNext()) {
                    NodeType nt = it.nextNodeType();
                    pw.printf("[%s]", nt.getName());
                    this.printSuperTypes(pw, nt);
                    if (nt.hasOrderableChildNodes()) {
                        pw.print(" orderable");
                    }
                    if (nt.isMixin()) {
                        pw.print(" mixin");
                    }
                    this.linebreak(pw, mode);
                    for (PropertyDefinition propertyDefinition : nt.getPropertyDefinitions()) {
                        if (propertyDefinition.getDeclaringNodeType() == nt) {
                            this.startBold(pw, mode);
                        }
                        pw.printf("- %s", propertyDefinition.getName());
                        this.printDefaultValues(pw, propertyDefinition);
                        if (propertyDefinition.getName().equals(nt.getPrimaryItemName())) {
                            pw.print(" primary");
                        }
                        if (propertyDefinition.isMandatory()) {
                            pw.print(" mandatory");
                        }
                        if (propertyDefinition.isAutoCreated()) {
                            pw.print(" autocreated");
                        }
                        if (propertyDefinition.isProtected()) {
                            pw.print(" protected");
                        }
                        if (propertyDefinition.isMultiple()) {
                            pw.print(" multiple");
                        }
                        pw.printf(" %s", OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()));
                        this.printConstraints(pw, propertyDefinition);
                        if (propertyDefinition.getDeclaringNodeType() == nt) {
                            this.stopBold(pw, mode);
                        }
                        this.linebreak(pw, mode);
                    }
                    for (PropertyDefinition propertyDefinition : nt.getChildNodeDefinitions()) {
                        if (propertyDefinition.getDeclaringNodeType() == nt) {
                            this.startBold(pw, mode);
                        }
                        pw.printf("+ %s", propertyDefinition.getName());
                        this.printRequiredChildTypes(pw, (NodeDefinition)propertyDefinition);
                        if (propertyDefinition.getDefaultPrimaryType() != null) {
                            pw.printf(" = %s", propertyDefinition.getDefaultPrimaryType().getName());
                        }
                        if (propertyDefinition.isMandatory()) {
                            pw.print(" mandatory");
                        }
                        if (propertyDefinition.isAutoCreated()) {
                            pw.print(" autocreated");
                        }
                        if (propertyDefinition.isProtected()) {
                            pw.print(" protected");
                        }
                        if (propertyDefinition.allowsSameNameSiblings()) {
                            pw.print(" multiple");
                        }
                        pw.printf(" %s", OnParentVersionAction.nameFromValue((int)propertyDefinition.getOnParentVersion()));
                        if (propertyDefinition.getDeclaringNodeType() == nt) {
                            this.stopBold(pw, mode);
                        }
                        this.linebreak(pw, mode);
                    }
                    this.linebreak(pw, mode);
                }
            }
            catch (RepositoryException e) {
                pw.println("Unable to output namespace mappings.");
                e.printStackTrace(pw);
            }
        } else {
            pw.println("SlingRepsoitory is not available.");
        }
    }

    public void printConfiguration(PrintWriter pw) {
        this.printConfiguration(pw, "txt");
    }

    private void linebreak(PrintWriter pw, String mode) {
        if ("web".equals(mode)) {
            pw.println("<br/>");
        } else {
            pw.println();
        }
    }

    private void stopBold(PrintWriter pw, String mode) {
        if ("web".equals(mode)) {
            pw.print("</b>");
        }
    }

    private void startBold(PrintWriter pw, String mode) {
        if ("web".equals(mode)) {
            pw.print("<b>");
        }
    }

    private void printRequiredChildTypes(PrintWriter pw, NodeDefinition child) {
        if (child.getRequiredPrimaryTypes() != null && child.getRequiredPrimaryTypes().length > 0) {
            pw.print(" (");
            boolean first = true;
            for (NodeType required : child.getRequiredPrimaryTypes()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(required.getName());
                first = false;
            }
            pw.print(")");
        }
    }

    private void printDefaultValues(PrintWriter pw, PropertyDefinition prop) throws RepositoryException {
        if (prop.getDefaultValues() != null && prop.getDefaultValues().length > 0) {
            pw.print(" = ");
            boolean first = true;
            for (Value v : prop.getDefaultValues()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(v.getString());
                first = false;
            }
        }
    }

    private void printConstraints(PrintWriter pw, PropertyDefinition prop) throws RepositoryException {
        if (prop.getValueConstraints() != null && prop.getValueConstraints().length > 0) {
            pw.print(" < ");
            boolean first = true;
            for (String s : prop.getValueConstraints()) {
                if (!first) {
                    pw.print(", ");
                }
                pw.print(s);
                first = false;
            }
        }
    }

    private void printSuperTypes(PrintWriter pw, NodeType nt) {
        pw.print(" > ");
        boolean first = true;
        for (NodeType st : nt.getSupertypes()) {
            if (!first) {
                pw.print(", ");
            }
            pw.print(st.getName());
            first = false;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

