/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.jcr.api.SlingRepository;

public class NamespaceConfigurationPrinter
implements ConfigurationPrinter {
    private SlingRepository slingRepository;

    public String getTitle() {
        return "JCR Namespaces";
    }

    public void printConfiguration(PrintWriter pw) {
        if (this.slingRepository != null) {
            try {
                Session session = this.slingRepository.loginAdministrative(null);
                NamespaceRegistry reg = session.getWorkspace().getNamespaceRegistry();
                List<String> globalPrefixes = Arrays.asList(reg.getPrefixes());
                for (String prefix : session.getNamespacePrefixes()) {
                    if (prefix.length() <= 0) continue;
                    pw.printf("%10s = %s", prefix, session.getNamespaceURI(prefix));
                    if (globalPrefixes.contains(prefix)) {
                        pw.print(" [global]");
                    } else {
                        pw.print(" [local]");
                    }
                    pw.println();
                }
            }
            catch (RepositoryException e) {
                pw.println("Unable to output namespace mappings.");
                e.printStackTrace(pw);
            }
        } else {
            pw.println("SlingRepository is not available.");
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

