/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl.jmx;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsMBeanImpl
implements DynamicMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsMBeanImpl.class);
    private RepositoryStatisticsImpl statistics;

    public StatisticsMBeanImpl(RepositoryImpl repositoryImpl) throws IllegalArgumentException {
        try {
            Field contextField = RepositoryImpl.class.getDeclaredField("context");
            if (!contextField.isAccessible()) {
                contextField.setAccessible(true);
            }
            RepositoryContext respositoryContext = (RepositoryContext)contextField.get(repositoryImpl);
            this.statistics = respositoryContext.getRepositoryStatistics();
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getMBeanName(RepositoryImpl repositoryImpl) {
        return "org.apache.sling:type=Repository,name=" + repositoryImpl.getConfig().getSecurityConfig().getAppName();
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.statistics == null) {
            throw new AttributeNotFoundException("No Statistics Available");
        }
        try {
            if (attribute.startsWith("PerSecond_")) {
                return this.getTimeSeries(attribute.substring("PerSecond_".length())).getValuePerSecond();
            }
            if (attribute.startsWith("PerMinute_")) {
                return this.getTimeSeries(attribute.substring("PerMinute_".length())).getValuePerMinute();
            }
            if (attribute.startsWith("PerHour_")) {
                return this.getTimeSeries(attribute.substring("PerHour_".length())).getValuePerHour();
            }
            if (attribute.startsWith("PerWeek_")) {
                return this.getTimeSeries(attribute.substring("PerWeek_".length())).getValuePerWeek();
            }
            if (attribute.startsWith("LastMinutePerSecond_")) {
                return this.getCurrentValue(this.getTimeSeries(attribute.substring("LastMinutePerSecond_".length())).getValuePerSecond());
            }
            if (attribute.startsWith("LastHourPerMinute_")) {
                return this.getCurrentValue(this.getTimeSeries(attribute.substring("LastHourPerMinute_".length())).getValuePerMinute());
            }
            if (attribute.startsWith("LastWeekPerHour_")) {
                return this.getCurrentValue(this.getTimeSeries(attribute.substring("LastWeekPerHour_".length())).getValuePerHour());
            }
            if (attribute.startsWith("LastYearPerWeek_")) {
                return this.getCurrentValue(this.getTimeSeries(attribute.substring("LastYearPerWeek_".length())).getValuePerWeek());
            }
        }
        catch (AttributeNotFoundException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return this.getTimeSeries(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (this.statistics == null) {
            return new AttributeList();
        }
        AttributeList al = new AttributeList();
        for (Map.Entry<String, TimeSeries> entry : this.statistics) {
            long[] valuePerSecond = entry.getValue().getValuePerSecond();
            al.add(new Attribute("PerSecond_" + entry.getKey(), valuePerSecond[valuePerSecond.length - 1]));
            al.add(new Attribute("LastMinutePerSecond_" + entry.getKey(), valuePerSecond));
            long[] valuePerMinute = entry.getValue().getValuePerMinute();
            al.add(new Attribute("PerMinute" + entry.getKey(), valuePerMinute[valuePerMinute.length - 1]));
            al.add(new Attribute("LastHourPerMinute_" + entry.getKey(), valuePerMinute));
            long[] valuePerHour = entry.getValue().getValuePerHour();
            al.add(new Attribute("PerHour_" + entry.getKey(), valuePerHour[valuePerHour.length - 1]));
            al.add(new Attribute("LastWeekPerHour_" + entry.getKey(), valuePerHour));
            long[] valuePerWeek = entry.getValue().getValuePerWeek();
            al.add(new Attribute("PerWeek_" + entry.getKey(), valuePerWeek[valuePerWeek.length - 1]));
            al.add(new Attribute("LastYearPerWeek_" + entry.getKey(), valuePerWeek));
        }
        return al;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.statistics == null) {
            return new MBeanInfo(this.getClass().getName(), "Repository Statistics Unavailable", null, null, null, null);
        }
        ArrayList<MBeanAttributeInfo> attributesList = new ArrayList<MBeanAttributeInfo>();
        HashSet<String> typeNames = new HashSet<String>();
        for (Map.Entry<String, TimeSeries> entry : this.statistics) {
            attributesList.add(new MBeanAttributeInfo("PerSecond_" + entry.getKey(), Long.TYPE.getName(), "Current per second value of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("LastMinutePerSecond_" + entry.getKey(), long[].class.getName(), "Last minute of per seconds values of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("PerMinute" + entry.getKey(), Long.TYPE.getName(), "Current per minute value of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("LastHourPerMinute_" + entry.getKey(), long[].class.getName(), "Last hour of per minute values of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("PerHour_" + entry.getKey(), Long.TYPE.getName(), "Current per hour value of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("LastWeekPerHour_" + entry.getKey(), long[].class.getName(), "Last week of per hour values of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("PerWeek_" + entry.getKey(), Long.TYPE.getName(), "Current per week value of " + entry.getKey(), true, false, false));
            attributesList.add(new MBeanAttributeInfo("LastYearPerWeek_" + entry.getKey(), long[].class.getName(), "Last year of per week values of " + entry.getKey(), true, false, false));
            typeNames.add(entry.getKey());
        }
        for (RepositoryStatistics.Type t : RepositoryStatistics.Type.values()) {
            String name = t.name();
            if (typeNames.contains(name)) continue;
            attributesList.add(new MBeanAttributeInfo(name, Long.TYPE.getName(), "Current counter value of " + name, true, false, false));
            typeNames.add(name);
        }
        MBeanAttributeInfo[] attributes = attributesList.toArray(new MBeanAttributeInfo[attributesList.size()]);
        return new MBeanInfo(this.getClass().getName(), "Repository Statistics", attributes, null, null, null);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return new UnsupportedOperationException();
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("read only");
    }

    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("read only");
    }

    public TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
        if (this.statistics == null) {
            throw new IllegalStateException("Repository statistics are not available");
        }
        return this.statistics.getTimeSeries(type);
    }

    private long getCurrentValue(long[] values) {
        return values[values.length - 1];
    }

    private TimeSeries getTimeSeries(String name) throws AttributeNotFoundException {
        try {
            TimeSeries ts = this.statistics.getTimeSeries(RepositoryStatistics.Type.valueOf((String)name));
            if (ts == null) {
                throw new AttributeNotFoundException("Attribute " + name + " doesnt exist");
            }
            return ts;
        }
        catch (Exception e) {
            throw new AttributeNotFoundException("Attribute " + name + " doesnt exist");
        }
    }
}

