/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.sling.jcr.jackrabbit.server.impl.AccessManagerFactoryTracker;
import org.apache.sling.jcr.jackrabbit.server.impl.SlingServerRepositoryManager;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    public static final String SERVER_REPOSITORY_FACTORY_PID = "org.apache.sling.jcr.jackrabbit.server.SlingServerRepository";
    public static final String SLING_CONTEXT = "sling.context";
    public static final String SLING_CONTEXT_DEFAULT = "sling.context.default";
    private static final String CONFIG_ADMIN_NAME = ConfigurationAdmin.class.getName();
    private static BundleContext bundleContext;
    private static ServiceTracker loginModuleTracker;
    private static int lastTrackingCount;
    private static LoginModulePlugin[] moduleCache;
    private static LoginModulePlugin[] EMPTY;
    private String slingContext;
    private static AccessManagerFactoryTracker accessManagerFactoryTracker;

    protected String getRepositoryName() {
        String repoName = bundleContext.getProperty("sling.repository.name");
        if (repoName != null) {
            return repoName;
        }
        return "jackrabbit";
    }

    public void start(BundleContext context) {
        ServiceReference sr;
        bundleContext = context;
        moduleCache = null;
        this.slingContext = context.getProperty(SLING_CONTEXT_DEFAULT);
        if (this.slingContext == null) {
            this.slingContext = "default";
        }
        if ((sr = context.getServiceReference(CONFIG_ADMIN_NAME)) != null) {
            this.verifyConfiguration(sr);
        } else {
            try {
                bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + CONFIG_ADMIN_NAME + ")");
            }
            catch (InvalidSyntaxException ise) {
                log.error("start: Failed to register for Configuration Admin Service, will not verify configuration", (Throwable)ise);
            }
        }
        if (accessManagerFactoryTracker == null) {
            accessManagerFactoryTracker = new AccessManagerFactoryTracker(bundleContext);
        }
        accessManagerFactoryTracker.open();
    }

    public void stop(BundleContext arg0) {
        moduleCache = null;
        if (loginModuleTracker != null) {
            loginModuleTracker.close();
            loginModuleTracker = null;
        }
        if (accessManagerFactoryTracker != null) {
            accessManagerFactoryTracker.close();
            accessManagerFactoryTracker = null;
        }
        bundleContext = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.verifyConfiguration(event.getServiceReference());
            bundleContext.removeServiceListener((ServiceListener)this);
        }
    }

    private static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static LoginModulePlugin[] getLoginModules() {
        if (moduleCache != null && lastTrackingCount == loginModuleTracker.getTrackingCount()) {
            return moduleCache;
        }
        if (loginModuleTracker == null) {
            loginModuleTracker = new ServiceTracker(Activator.getBundleContext(), LoginModulePlugin.class.getName(), null);
            loginModuleTracker.open();
        }
        if (moduleCache == null || lastTrackingCount < loginModuleTracker.getTrackingCount()) {
            Object[] services = loginModuleTracker.getServices();
            if (services == null || services.length == 0) {
                moduleCache = EMPTY;
            } else {
                moduleCache = new LoginModulePlugin[services.length];
                System.arraycopy(services, 0, moduleCache, 0, services.length);
            }
            lastTrackingCount = loginModuleTracker.getTrackingCount();
        }
        return moduleCache;
    }

    public static AccessManagerFactoryTracker getAccessManagerFactoryTracker() {
        return accessManagerFactoryTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConfiguration(ServiceReference ref) {
        ConfigurationAdmin ca = (ConfigurationAdmin)bundleContext.getService(ref);
        if (ca == null) {
            log.error("verifyConfiguration: Failed to get Configuration Admin Service from Service Reference");
            return;
        }
        try {
            Configuration[] cfgs = ca.listConfigurations("(service.factoryPid=org.apache.sling.jcr.jackrabbit.server.SlingServerRepository)");
            if (cfgs != null && cfgs.length > 0) {
                log.info("verifyConfiguration: {} Configurations available for {}, nothing to do", new Object[]{new Integer(cfgs.length), SERVER_REPOSITORY_FACTORY_PID});
                return;
            }
            Hashtable<String, String> defaultConfig = new Hashtable<String, String>();
            String overrideUrl = bundleContext.getProperty("sling.repository.url");
            if (overrideUrl != null && overrideUrl.length() > 0) {
                defaultConfig.put("sling.repository.url", overrideUrl);
                log.info("sling.repository.url=" + overrideUrl + ", using it to create the default configuration");
            } else {
                this.initDefaultConfig(defaultConfig, bundleContext);
            }
            Configuration config = ca.createFactoryConfiguration(SERVER_REPOSITORY_FACTORY_PID);
            config.update(defaultConfig);
            log.info("verifyConfiguration: Created configuration {} for {}", (Object)config.getPid(), (Object)config.getFactoryPid());
        }
        catch (Throwable t) {
            log.error("verifyConfiguration: Cannot check or define configuration", t);
        }
        finally {
            bundleContext.ungetService(ref);
        }
    }

    private void initDefaultConfig(Hashtable<String, String> props, BundleContext bundleContext) throws IOException {
        String slingHomePath = bundleContext.getProperty("sling.home");
        String home = this.getHomePath(bundleContext, slingHomePath);
        if (home == null) {
            return;
        }
        String configFileUrl = this.getConfigFileUrl(bundleContext, home);
        if (slingHomePath != null && home.startsWith(slingHomePath + "/")) {
            home = home.substring(slingHomePath.length() + 1);
        }
        props.put(SLING_CONTEXT, this.slingContext);
        if (configFileUrl != null) {
            props.put("config", configFileUrl);
        }
        props.put("home", home);
        props.put("name", this.getRepositoryName());
        props.put("admin.password", "not-used");
        props.put("anonymous.password", "not-used");
    }

    private String getHomePath(BundleContext bundleContext, String slingHomePath) {
        String repoHomePath = bundleContext.getProperty("sling.repository.home");
        File homeDir = repoHomePath != null ? new File(repoHomePath, this.getRepositoryName()) : (slingHomePath != null ? new File(slingHomePath, this.getRepositoryName()) : new File(this.getRepositoryName()));
        log.info("Creating default config for Jackrabbit in " + homeDir);
        if (!homeDir.isDirectory() && !homeDir.mkdirs()) {
            log.info("verifyConfiguration: Cannot create Jackrabbit home " + homeDir + ", failed creating default configuration");
            return null;
        }
        return homeDir.getPath();
    }

    private String getConfigFileUrl(BundleContext bundleContext, String home) throws IOException {
        block7: {
            String repoConfigFileUrl = bundleContext.getProperty("sling.repository.config.file.url");
            if (repoConfigFileUrl != null) {
                URL configFileUrl = null;
                try {
                    configFileUrl = new URL(repoConfigFileUrl);
                    return repoConfigFileUrl;
                }
                catch (MalformedURLException e) {
                    configFileUrl = new URL("file:///" + repoConfigFileUrl);
                    File configFile = new File(configFileUrl.getFile());
                    if (!configFile.canRead()) break block7;
                    return configFileUrl.toString();
                }
            }
        }
        File configFile = new File(home, "repository.xml");
        boolean copied = false;
        try {
            URL contextConfigURL = new URL("context:repository.xml");
            InputStream contextConfigStream = contextConfigURL.openStream();
            if (contextConfigStream != null) {
                SlingServerRepositoryManager.copyStream(contextConfigStream, configFile);
                copied = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!copied) {
            SlingServerRepositoryManager.copyFile(bundleContext.getBundle(), "repository.xml", configFile);
        }
        return null;
    }

    static {
        lastTrackingCount = -1;
        EMPTY = new LoginModulePlugin[0];
    }
}

