/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;

public class FineGrainedISMLocking
implements ISMLocking {
    private static final Integer ONE = new Integer(1);
    private final ISMLocking.ReadLock anonymousReadLock = new ReadLockImpl();
    private WriteLockImpl activeWriter;
    private volatile Object activeWriterId;
    private ReadWriteLock writerStateRWLock = new WriterPreferenceReadWriteLock();
    private final LockMap readLockMap = new LockMap();
    private final AtomicInteger readerCount = new AtomicInteger(0);
    private List<Sync> waitingReaders = Collections.synchronizedList(new LinkedList());
    private List<Sync> waitingWriters = new LinkedList<Sync>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        if (TransactionContext.isSameThreadId(this.activeWriterId, TransactionContext.getCurrentThreadId())) {
            this.readerCount.incrementAndGet();
            this.readLockMap.addLock(id);
            return new ReadLockImpl(id);
        }
        while (true) {
            Latch signal;
            Sync shared = this.writerStateRWLock.readLock();
            shared.acquire();
            try {
                if (this.activeWriter == null || !FineGrainedISMLocking.hasDependency(this.activeWriter.changes, id)) {
                    this.readerCount.incrementAndGet();
                    this.readLockMap.addLock(id);
                    ReadLockImpl readLockImpl = new ReadLockImpl(id);
                    return readLockImpl;
                }
                signal = new Latch();
                this.waitingReaders.add((Sync)signal);
            }
            finally {
                shared.release();
            }
            signal.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        while (true) {
            Latch signal;
            Sync exclusive = this.writerStateRWLock.writeLock();
            exclusive.acquire();
            try {
                if (this.activeWriter == null && !this.readLockMap.hasDependency(changeLog)) {
                    this.activeWriter = new WriteLockImpl(changeLog);
                    this.activeWriterId = TransactionContext.getCurrentThreadId();
                    WriteLockImpl writeLockImpl = this.activeWriter;
                    return writeLockImpl;
                }
                signal = new Latch();
                this.waitingWriters.add((Sync)signal);
            }
            finally {
                exclusive.release();
            }
            signal.acquire();
        }
    }

    private static boolean hasDependency(ChangeLog changeLog, ItemId id) {
        try {
            if (!(changeLog.get(id) != null || id.denotesNode() && changeLog.getReferencesTo((NodeId)id) != null)) {
                return false;
            }
        }
        catch (NoSuchItemStateException noSuchItemStateException) {
            // empty catch block
        }
        return true;
    }

    private void notifyWaitingReaders() {
        Iterator<Sync> it = this.waitingReaders.iterator();
        while (it.hasNext()) {
            it.next().release();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingWriters() {
        List<Sync> list = this.waitingWriters;
        synchronized (list) {
            if (this.waitingWriters.isEmpty()) {
                return;
            }
            Iterator<Sync> it = this.waitingWriters.iterator();
            while (it.hasNext()) {
                it.next().release();
                it.remove();
            }
        }
    }

    private static final class LockMap {
        private final Map<ItemId, Integer>[] slots = new Map[16];
        private volatile boolean global = false;

        public LockMap() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = new HashMap<ItemId, Integer>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLock(ItemId id) {
            Map<ItemId, Integer> locks;
            if (id == null) {
                if (this.global) {
                    throw new IllegalStateException("Map already globally locked");
                }
                this.global = true;
                return;
            }
            Map<ItemId, Integer> map = locks = this.slots[LockMap.slotIndex(id)];
            synchronized (map) {
                Integer i = locks.get(id);
                i = i == null ? ONE : new Integer(i + 1);
                locks.put(id, i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLock(ItemId id) {
            Map<ItemId, Integer> locks;
            if (id == null) {
                if (!this.global) {
                    throw new IllegalStateException("Map not globally locked");
                }
                this.global = false;
                return;
            }
            Map<ItemId, Integer> map = locks = this.slots[LockMap.slotIndex(id)];
            synchronized (map) {
                Integer i = locks.get(id);
                if (i != null) {
                    if (i == 1) {
                        locks.remove(id);
                    } else {
                        locks.put(id, new Integer(i - 1));
                    }
                } else {
                    throw new IllegalStateException("No lock present for id: " + id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasDependency(ChangeLog changes) {
            if (this.global) {
                return true;
            }
            for (int i = 0; i < this.slots.length; ++i) {
                Map<ItemId, Integer> locks;
                Map<ItemId, Integer> map = locks = this.slots[i];
                synchronized (map) {
                    for (ItemId id : locks.keySet()) {
                        if (!FineGrainedISMLocking.hasDependency(changes, id)) continue;
                        return true;
                    }
                    continue;
                }
            }
            return false;
        }

        private static int slotIndex(ItemId id) {
            NodeId nodeId = id.denotesNode() ? (NodeId)id : ((PropertyId)id).getParentId();
            return (int)nodeId.getLeastSignificantBits() & 0xF;
        }
    }

    private final class ReadLockImpl
    implements ISMLocking.ReadLock {
        private final ItemId id;

        public ReadLockImpl() {
            this(null);
        }

        ReadLockImpl(ItemId id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Sync shared = FineGrainedISMLocking.this.writerStateRWLock.readLock();
            while (true) {
                try {
                    shared.acquire();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            try {
                FineGrainedISMLocking.this.readLockMap.removeLock(this.id);
                if (FineGrainedISMLocking.this.readerCount.decrementAndGet() == 0 && FineGrainedISMLocking.this.activeWriter == null) {
                    FineGrainedISMLocking.this.activeWriterId = null;
                }
                if (!TransactionContext.isSameThreadId(FineGrainedISMLocking.this.activeWriterId, TransactionContext.getCurrentThreadId())) {
                    FineGrainedISMLocking.this.notifyWaitingWriters();
                }
            }
            finally {
                shared.release();
            }
        }
    }

    private final class WriteLockImpl
    implements ISMLocking.WriteLock {
        private final ChangeLog changes;

        WriteLockImpl(ChangeLog changes) {
            this.changes = changes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Sync exclusive = FineGrainedISMLocking.this.writerStateRWLock.writeLock();
            while (true) {
                try {
                    exclusive.acquire();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            try {
                FineGrainedISMLocking.this.activeWriter = null;
                FineGrainedISMLocking.this.activeWriterId = null;
                FineGrainedISMLocking.this.notifyWaitingReaders();
                FineGrainedISMLocking.this.notifyWaitingWriters();
            }
            finally {
                exclusive.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ISMLocking.ReadLock downgrade() {
            FineGrainedISMLocking.this.readerCount.incrementAndGet();
            FineGrainedISMLocking.this.readLockMap.addLock(null);
            Sync exclusive = FineGrainedISMLocking.this.writerStateRWLock.writeLock();
            while (true) {
                try {
                    exclusive.acquire();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            try {
                FineGrainedISMLocking.this.activeWriter = null;
                FineGrainedISMLocking.this.notifyWaitingReaders();
            }
            finally {
                exclusive.release();
            }
            return FineGrainedISMLocking.this.anonymousReadLock;
        }
    }
}

