/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.IndexNodeResolver;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.core.security.user.PasswordUtility;
import org.apache.jackrabbit.core.security.user.TraversingNodeResolver;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserImpl;
import org.apache.jackrabbit.core.security.user.UserManagerConfig;
import org.apache.jackrabbit.core.security.user.XPathQueryBuilder;
import org.apache.jackrabbit.core.security.user.XPathQueryEvaluator;
import org.apache.jackrabbit.core.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
extends ProtectedItemModifier
implements UserManager,
UserConstants,
SessionListener {
    public static final String PARAM_USERS_PATH = "usersPath";
    public static final String PARAM_GROUPS_PATH = "groupsPath";
    public static final String PARAM_COMPATIBILE_JR16 = "compatibleJR16";
    public static final String PARAM_COMPATIBLE_JR16 = "compatibleJR16";
    public static final String PARAM_DEFAULT_DEPTH = "defaultDepth";
    public static final String PARAM_AUTO_EXPAND_TREE = "autoExpandTree";
    public static final String PARAM_AUTO_EXPAND_SIZE = "autoExpandSize";
    public static final String PARAM_GROUP_MEMBERSHIP_SPLIT_SIZE = "groupMembershipSplitSize";
    public static final String PARAM_PASSWORD_HASH_ALGORITHM = "passwordHashAlgorithm";
    public static final String PARAM_PASSWORD_HASH_ITERATIONS = "passwordHashIterations";
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final SessionImpl session;
    private final String adminId;
    private final NodeResolver authResolver;
    private final NodeCreator nodeCreator;
    private final UserManagerConfig config;
    private final String usersPath;
    private final String groupsPath;
    private final MembershipCache membershipCache;

    public UserManagerImpl(SessionImpl session, String adminId) throws RepositoryException {
        this(session, adminId, null, null);
    }

    public UserManagerImpl(SessionImpl session, String adminId, Properties config) throws RepositoryException {
        this(session, adminId, config, null);
    }

    public UserManagerImpl(SessionImpl session, String adminId, Properties config, MembershipCache mCache) throws RepositoryException {
        this(session, new UserManagerConfig(config, adminId, null), mCache);
    }

    private UserManagerImpl(SessionImpl session, UserManagerConfig config, MembershipCache mCache) throws RepositoryException {
        NodeResolver nr;
        this.session = session;
        this.adminId = config.getAdminId();
        this.config = config;
        this.nodeCreator = new NodeCreator(config);
        this.usersPath = config.getConfigValue(PARAM_USERS_PATH, "/rep:security/rep:authorizables/rep:users");
        this.groupsPath = config.getConfigValue(PARAM_GROUPS_PATH, "/rep:security/rep:authorizables/rep:groups");
        this.membershipCache = mCache != null ? mCache : new MembershipCache(session, this.groupsPath, this.hasMemberSplitSize());
        try {
            nr = new IndexNodeResolver((Session)session, session);
        }
        catch (RepositoryException e) {
            log.debug("UserManager: no QueryManager available for workspace '" + session.getWorkspace().getName() + "' -> Use traversing node resolver.");
            nr = new TraversingNodeResolver((Session)session, session);
        }
        this.authResolver = nr;
        this.authResolver.setSearchRoots(this.usersPath, this.groupsPath);
    }

    public String getUsersPath() {
        return this.usersPath;
    }

    public String getGroupsPath() {
        return this.groupsPath;
    }

    public MembershipCache getMembershipCache() {
        return this.membershipCache;
    }

    public int getMemberSplitSize() {
        int splitSize = this.config.getConfigValue(PARAM_GROUP_MEMBERSHIP_SPLIT_SIZE, 0);
        if (splitSize != 0 && splitSize < 4) {
            log.warn("Invalid value {} for {}. Expected integer >= 4", (Object)splitSize, (Object)PARAM_GROUP_MEMBERSHIP_SPLIT_SIZE);
            splitSize = 0;
        }
        return splitSize;
    }

    public boolean hasMemberSplitSize() {
        return this.getMemberSplitSize() >= 4;
    }

    public void setAuthorizableActions(AuthorizableAction[] authorizableActions) {
        this.config.setAuthorizableActions(authorizableActions);
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid authorizable name '" + id + "'");
        }
        Authorizable a = this.internalGetAuthorizable(id);
        if (a == null && this.adminId.equals(id) && this.session.isSystem()) {
            log.info("Admin user does not exist.");
            a = this.createAdmin();
        }
        return a;
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        NodeImpl n = null;
        if (principal instanceof AuthorizableImpl.NodeBasedPrincipal) {
            NodeId nodeId = ((AuthorizableImpl.NodeBasedPrincipal)((Object)principal)).getNodeId();
            try {
                n = this.session.getNodeById(nodeId);
            }
            catch (ItemNotFoundException e) {}
        } else if (principal instanceof ItemBasedPrincipal) {
            String authPath = ((ItemBasedPrincipal)principal).getPath();
            if (this.session.nodeExists(authPath)) {
                n = (NodeImpl)this.session.getNode(authPath);
            }
        } else {
            String name = principal.getName();
            try {
                Authorizable a = this.internalGetAuthorizable(name);
                if (a != null && name.equals(a.getPrincipal().getName())) {
                    return a;
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            n = (NodeImpl)this.authResolver.findNode(P_PRINCIPAL_NAME, name, NT_REP_AUTHORIZABLE);
        }
        return this.getAuthorizable(n);
    }

    public Authorizable getAuthorizableByPath(String path) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value, int searchType) throws RepositoryException {
        NodeIterator nodes;
        if (searchType < 1 || searchType > 3) {
            throw new IllegalArgumentException("Invalid search type " + searchType);
        }
        Path path = this.session.getQPath(relPath);
        if (relPath.indexOf(47) == -1) {
            nodes = this.authResolver.findNodes(path, value, searchType, true, Long.MAX_VALUE);
        } else if ((path = path.getNormalizedPath()).getLength() == 1) {
            Name ntName;
            switch (searchType) {
                case 2: {
                    ntName = NT_REP_GROUP;
                    break;
                }
                case 1: {
                    ntName = NT_REP_USER;
                    break;
                }
                default: {
                    ntName = NT_REP_AUTHORIZABLE;
                }
            }
            nodes = this.authResolver.findNodes(path.getName(), value, ntName, true);
        } else {
            nodes = this.authResolver.findNodes(path, value, searchType, true, Long.MAX_VALUE);
        }
        return new AuthorizableIterator(nodes);
    }

    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        XPathQueryBuilder builder = new XPathQueryBuilder();
        query.build((QueryBuilder)builder);
        return new XPathQueryEvaluator(builder, this, this.session).eval();
    }

    public User createUser(String userID, String password) throws RepositoryException {
        return this.createUser(userID, password, (Principal)((Object)new PrincipalImpl(userID)), null);
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        this.checkValidID(userID);
        try {
            NodeImpl userNode = (NodeImpl)this.nodeCreator.createUserNode(userID, intermediatePath);
            this.setPrincipal(userNode, principal);
            this.setPassword(userNode, password, true);
            User user = this.createUser(userNode);
            this.onCreate(user, password);
            if (this.isAutoSave()) {
                this.session.save();
            }
            log.debug("User created: " + userID + "; " + userNode.getPath());
            return user;
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("Failed to create new User, reverting changes.");
            throw e;
        }
    }

    public Group createGroup(String groupID) throws AuthorizableExistsException, RepositoryException {
        return this.createGroup(groupID, (Principal)((Object)new PrincipalImpl(groupID)), null);
    }

    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    public Group createGroup(Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        UserManagerImpl.checkValidPrincipal(principal, true);
        String groupID = this.getGroupId(principal.getName());
        return this.createGroup(groupID, principal, intermediatePath);
    }

    public Group createGroup(String groupID, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        this.checkValidID(groupID);
        try {
            NodeImpl groupNode = (NodeImpl)this.nodeCreator.createGroupNode(groupID, intermediatePath);
            if (principal != null) {
                this.setPrincipal(groupNode, principal);
            }
            Group group = this.createGroup(groupNode);
            this.onCreate(group);
            if (this.isAutoSave()) {
                this.session.save();
            }
            log.debug("Group created: " + groupID + "; " + groupNode.getPath());
            return group;
        }
        catch (RepositoryException e) {
            this.session.refresh(false);
            log.debug("newInstance new Group failed, revert changes on parent");
            throw e;
        }
    }

    public boolean isAutoSave() {
        return true;
    }

    public void autoSave(boolean enable) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Cannot change autosave behavior.");
    }

    void setPrincipal(NodeImpl node, Principal principal) throws AuthorizableExistsException, RepositoryException {
        UserManagerImpl.checkValidPrincipal(principal, node.isNodeType(NT_REP_GROUP));
        Authorizable existing = this.getAuthorizable(principal);
        if (existing != null && !((AuthorizableImpl)existing).getNode().isSame(node)) {
            throw new AuthorizableExistsException("Authorizable for '" + principal.getName() + "' already exists: ");
        }
        if (!node.isNew() || node.hasProperty(P_PRINCIPAL_NAME)) {
            throw new RepositoryException("rep:principalName can only be set once on a new node.");
        }
        this.setProperty(node, P_PRINCIPAL_NAME, this.getValue(principal.getName()), true);
    }

    void setPassword(NodeImpl userNode, String password, boolean forceHash) throws RepositoryException {
        String pwHash;
        if (password == null) {
            if (userNode.isNew()) {
                return;
            }
            throw new IllegalArgumentException("Password may not be null.");
        }
        if (forceHash || PasswordUtility.isPlainTextPassword(password)) {
            try {
                String algorithm = this.config.getConfigValue(PARAM_PASSWORD_HASH_ALGORITHM, "SHA-256");
                int iterations = this.config.getConfigValue(PARAM_PASSWORD_HASH_ITERATIONS, 1000);
                pwHash = PasswordUtility.buildPasswordHash(password, algorithm, 8, iterations);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            pwHash = password;
        }
        Value v = this.getSession().getValueFactory().createValue(pwHash);
        this.setProperty(userNode, P_PASSWORD, this.getValue(pwHash), userNode.isNew());
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value value) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, value);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void setProtectedProperty(NodeImpl node, Name propName, Value[] values, int type) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        this.setProperty(node, propName, values, type);
        if (this.isAutoSave()) {
            node.save();
        }
    }

    void removeProtectedItem(ItemImpl item, Node parent) throws RepositoryException, AccessDeniedException, VersionException {
        this.removeItem(item);
        if (this.isAutoSave()) {
            parent.save();
        }
    }

    NodeImpl addProtectedNode(NodeImpl parent, Name name, Name ntName) throws RepositoryException {
        NodeImpl n = this.addNode(parent, name, ntName);
        if (this.isAutoSave()) {
            parent.save();
        }
        return n;
    }

    <T> T performProtectedOperation(SessionImpl session, SessionOperation<T> operation) throws RepositoryException {
        return this.performProtected(session, operation);
    }

    Authorizable getAuthorizable(NodeImpl n) throws RepositoryException {
        User authorz = null;
        if (n != null) {
            String path = n.getPath();
            if (n.isNodeType(NT_REP_USER)) {
                if (Text.isDescendant((String)this.usersPath, (String)path)) {
                    authorz = this.createUser(n);
                } else {
                    log.error("User node '" + path + "' outside of configured user tree ('" + this.usersPath + "') -> Not a valid user.");
                }
            } else if (n.isNodeType(NT_REP_GROUP)) {
                if (Text.isDescendant((String)this.groupsPath, (String)path)) {
                    authorz = this.createGroup(n);
                } else {
                    log.error("Group node '" + path + "' outside of configured group tree ('" + this.groupsPath + "') -> Not a valid group.");
                }
            } else {
                log.warn("Unexpected user/group node type " + n.getPrimaryNodeType().getName());
            }
        }
        return authorz;
    }

    String getPath(Node authorizableNode) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    SessionImpl getSession() {
        return this.session;
    }

    private String getGroupId(String principalName) throws RepositoryException {
        String groupID = principalName;
        int i = 0;
        while (this.internalGetAuthorizable(groupID) != null) {
            groupID = principalName + "_" + i;
            ++i;
        }
        return groupID;
    }

    private Authorizable internalGetAuthorizable(String id) throws RepositoryException {
        NodeImpl n;
        block2: {
            NodeId nodeId = this.buildNodeId(id);
            n = null;
            try {
                n = this.session.getNodeById(nodeId);
            }
            catch (ItemNotFoundException e) {
                boolean compatibleJR16 = this.config.getConfigValue("compatibleJR16", false);
                if (!compatibleJR16 || (n = (NodeImpl)this.authResolver.findNode(P_USERID, id, NT_REP_USER)) != null) break block2;
                Name nodeName = this.session.getQName(Text.escapeIllegalJcrChars((String)id));
                n = (NodeImpl)this.authResolver.findNode(nodeName, NT_REP_GROUP);
            }
        }
        return this.getAuthorizable(n);
    }

    private Value getValue(String strValue) {
        return this.session.getValueFactory().createValue(strValue);
    }

    boolean isAdminId(String userID) {
        return this.adminId != null && this.adminId.equals(userID);
    }

    User createUser(NodeImpl userNode) throws RepositoryException {
        if (userNode == null || !userNode.isNodeType(NT_REP_USER)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant((String)this.usersPath, (String)userNode.getPath())) {
            throw new RepositoryException("User has to be within the User Path");
        }
        return this.doCreateUser(userNode);
    }

    protected User doCreateUser(NodeImpl node) throws RepositoryException {
        return new UserImpl(node, this);
    }

    Group createGroup(NodeImpl groupNode) throws RepositoryException {
        if (groupNode == null || !groupNode.isNodeType(NT_REP_GROUP)) {
            throw new IllegalArgumentException();
        }
        if (!Text.isDescendant((String)this.groupsPath, (String)groupNode.getPath())) {
            throw new RepositoryException("Group has to be within the Group Path");
        }
        return this.doCreateGroup(groupNode);
    }

    protected Group doCreateGroup(NodeImpl node) throws RepositoryException {
        return new GroupImpl(node, this);
    }

    private User createAdmin() throws RepositoryException {
        User admin;
        try {
            admin = this.createUser(this.adminId, this.adminId);
            if (!this.isAutoSave()) {
                this.session.save();
            }
            log.info("... created admin user with id '" + this.adminId + "' and default pw.");
        }
        catch (ItemExistsException e) {
            NodeImpl conflictingNode = this.session.getNodeById(this.buildNodeId(this.adminId));
            String conflictPath = conflictingNode.getPath();
            log.error("Detected conflicting node " + conflictPath + " of node type " + conflictingNode.getPrimaryNodeType().getName() + ".");
            conflictingNode.remove();
            log.info("Removed conflicting node at " + conflictPath);
            admin = this.createUser(this.adminId, this.adminId);
            if (!this.isAutoSave()) {
                this.session.save();
            }
            log.info("Resolved conflict and (re)created admin user with id '" + this.adminId + "' and default pw.");
        }
        return admin;
    }

    private NodeId buildNodeId(String id) throws RepositoryException {
        try {
            UUID uuid = UUID.nameUUIDFromBytes(id.toLowerCase().getBytes("UTF-8"));
            return new NodeId(uuid);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Unexpected error while build ID hash", (Throwable)e);
        }
    }

    private void checkValidID(String id) throws IllegalArgumentException, AuthorizableExistsException, RepositoryException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Cannot create authorizable: ID can neither be null nor empty String.");
        }
        if (this.internalGetAuthorizable(id) != null) {
            throw new AuthorizableExistsException("User or Group for '" + id + "' already exists");
        }
    }

    private static void checkValidPrincipal(Principal principal, boolean isGroup) {
        if (principal == null || principal.getName() == null || "".equals(principal.getName())) {
            throw new IllegalArgumentException("Principal may not be null and must have a valid name.");
        }
        if (!isGroup && "everyone".equals(principal.getName())) {
            throw new IllegalArgumentException("'everyone' is a reserved group principal name.");
        }
    }

    void onCreate(User user, String pw) throws RepositoryException {
        for (AuthorizableAction action : this.config.getAuthorizableActions()) {
            action.onCreate(user, pw, (Session)this.session);
        }
    }

    void onCreate(Group group) throws RepositoryException {
        for (AuthorizableAction action : this.config.getAuthorizableActions()) {
            action.onCreate(group, (Session)this.session);
        }
    }

    void onRemove(Authorizable authorizable) throws RepositoryException {
        for (AuthorizableAction action : this.config.getAuthorizableActions()) {
            action.onRemove(authorizable, (Session)this.session);
        }
    }

    void onPasswordChange(User user, String password) throws RepositoryException {
        for (AuthorizableAction action : this.config.getAuthorizableActions()) {
            action.onPasswordChange(user, password, (Session)this.session);
        }
    }

    @Override
    public void loggingOut(SessionImpl session) {
    }

    @Override
    public void loggedOut(SessionImpl session) {
        if (session != this.session) {
            this.session.logout();
        }
    }

    private class NodeCreator {
        private static final String DELIMITER = "/";
        private static final int DEFAULT_DEPTH = 2;
        private static final long DEFAULT_SIZE = 1000L;
        private final int defaultDepth;
        private final boolean autoExpandTree;
        private final long autoExpandSize;

        private NodeCreator(UserManagerConfig config) {
            int d = 2;
            boolean expand = false;
            long size = 1000L;
            if (config != null) {
                d = config.getConfigValue(UserManagerImpl.PARAM_DEFAULT_DEPTH, 2);
                if (d <= 0) {
                    log.warn("Invalid defaultDepth '" + d + "' -> using default.");
                    d = 2;
                }
                expand = config.getConfigValue(UserManagerImpl.PARAM_AUTO_EXPAND_TREE, false);
                size = config.getConfigValue(UserManagerImpl.PARAM_AUTO_EXPAND_SIZE, 1000L);
                if (expand && size <= 0L) {
                    log.warn("Invalid autoExpandSize '" + size + "' -> using default.");
                    size = 1000L;
                }
            }
            this.defaultDepth = d;
            this.autoExpandTree = expand;
            this.autoExpandSize = size;
        }

        public Node createUserNode(String userID, String intermediatePath) throws RepositoryException {
            return this.createAuthorizableNode(userID, false, intermediatePath);
        }

        public Node createGroupNode(String groupID, String intermediatePath) throws RepositoryException {
            return this.createAuthorizableNode(groupID, true, intermediatePath);
        }

        private Node createAuthorizableNode(String id, boolean isGroup, String intermediatePath) throws RepositoryException {
            String escapedId = Text.escapeIllegalJcrChars((String)id);
            Node folder = this.createDefaultFolderNodes(id, escapedId, isGroup, intermediatePath);
            if (intermediatePath == null) {
                folder = this.createIntermediateFolderNodes(id, escapedId, folder);
            }
            Name nodeName = UserManagerImpl.this.session.getQName(escapedId);
            Name ntName = isGroup ? UserConstants.NT_REP_GROUP : UserConstants.NT_REP_USER;
            NodeId nid = UserManagerImpl.this.buildNodeId(id);
            while (((NodeImpl)folder).hasNode(nodeName)) {
                NodeImpl colliding = ((NodeImpl)folder).getNode(nodeName);
                if (colliding.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                    log.warn("Existing folder node collides with user/group to be created. Expanding path: " + colliding.getPath());
                    folder = colliding;
                    continue;
                }
                String msg = "Failed to create authorizable with id '" + id + "' : Detected conflicting node of unexpected nodetype '" + colliding.getPrimaryNodeType().getName() + "'.";
                log.error(msg);
                throw new ConstraintViolationException(msg);
            }
            if (UserManagerImpl.this.session.getItemManager().itemExists(nid)) {
                String msg = "Failed to create authorizable with id '" + id + "' : Detected conflict with existing node (NodeID: " + nid + ")";
                log.error(msg);
                throw new ItemExistsException(msg);
            }
            return UserManagerImpl.this.addNode((NodeImpl)folder, nodeName, ntName, nid);
        }

        private Node createDefaultFolderNodes(String id, String escapedId, boolean isGroup, String intermediatePath) throws RepositoryException {
            String defaultPath = this.getDefaultFolderPath(id, isGroup, intermediatePath);
            String[] segmts = defaultPath.split(DELIMITER);
            NodeImpl folder = (NodeImpl)UserManagerImpl.this.session.getRootNode();
            String authRoot = isGroup ? UserManagerImpl.this.groupsPath : UserManagerImpl.this.usersPath;
            for (String segment : segmts) {
                if (segment.length() < 1) continue;
                if (folder.hasNode(segment)) {
                    if (!Text.isDescendantOrEqual((String)authRoot, (String)(folder = (NodeImpl)folder.getNode(segment)).getPath()) || folder.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) continue;
                    throw new ConstraintViolationException("Invalid intermediate path. Must be of type rep:AuthorizableFolder.");
                }
                folder = UserManagerImpl.this.addNode(folder, UserManagerImpl.this.session.getQName(segment), UserConstants.NT_REP_AUTHORIZABLE_FOLDER);
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private String getDefaultFolderPath(String id, boolean isGroup, String intermediatePath) {
            StringBuilder bld = new StringBuilder();
            if (isGroup) {
                bld.append(UserManagerImpl.this.groupsPath);
            } else {
                bld.append(UserManagerImpl.this.usersPath);
            }
            if (intermediatePath == null) {
                StringBuilder lastSegment = new StringBuilder(this.defaultDepth);
                int idLength = id.length();
                for (int i = 0; i < this.defaultDepth; ++i) {
                    if (idLength > i) {
                        lastSegment.append(id.charAt(i));
                    } else {
                        lastSegment.append(id.charAt(idLength - 1));
                    }
                    bld.append(DELIMITER).append(Text.escapeIllegalJcrChars((String)lastSegment.toString()));
                }
            } else {
                if (intermediatePath.startsWith(bld.toString())) {
                    intermediatePath = intermediatePath.substring(bld.toString().length());
                }
                if (intermediatePath.length() > 0 && !DELIMITER.equals(intermediatePath)) {
                    if (!intermediatePath.startsWith(DELIMITER)) {
                        bld.append(DELIMITER);
                    }
                    bld.append(intermediatePath);
                }
            }
            return bld.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private Node createIntermediateFolderNodes(String id, String escapedId, Node folder) throws RepositoryException {
            if (!this.autoExpandTree) {
                return folder;
            }
            int segmLength = this.defaultDepth + 1;
            while (this.intermediateFolderNeeded(escapedId, folder)) {
                block6: {
                    String folderName = Text.escapeIllegalJcrChars((String)id.substring(0, segmLength));
                    if (folder.hasNode(folderName)) {
                        NodeImpl n = (NodeImpl)folder.getNode(folderName);
                        if (n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                            folder = n;
                            break block6;
                        } else {
                            if (!n.isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                                String msg = "Failed to create authorizable node: Detected conflict with node of unexpected nodetype '" + n.getPrimaryNodeType().getName() + "'.";
                                log.error(msg);
                                throw new ConstraintViolationException(msg);
                            }
                            log.warn("Auto-expanding aborted. An existing authorizable node '" + n.getName() + "'conflicts with intermediate folder to be created.");
                            break;
                        }
                    }
                    folder = UserManagerImpl.this.addNode((NodeImpl)folder, UserManagerImpl.this.session.getQName(folderName), UserConstants.NT_REP_AUTHORIZABLE_FOLDER);
                }
                ++segmLength;
            }
            this.checkAuthorizableNodeExists(escapedId, folder);
            return folder;
        }

        private void checkAuthorizableNodeExists(String nodeName, Node folder) throws AuthorizableExistsException, RepositoryException {
            if (folder.hasNode(nodeName) && ((NodeImpl)folder.getNode(nodeName)).isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                throw new AuthorizableExistsException("Unable to create Group/User: Collision with existing authorizable.");
            }
        }

        private boolean intermediateFolderNeeded(String nodeName, Node folder) throws RepositoryException {
            if (nodeName.length() <= folder.getName().length()) {
                return false;
            }
            if (nodeName.length() == folder.getName().length() + 1) {
                return true;
            }
            return folder.getNodes().getSize() >= this.autoExpandSize;
        }
    }

    private final class AuthorizableIterator
    implements Iterator<Authorizable> {
        private final Set<String> served = new HashSet<String>();
        private Authorizable next;
        private final NodeIterator authNodeIter;

        private AuthorizableIterator(NodeIterator authNodeIter) {
            this.authNodeIter = authNodeIter;
            this.next = this.seekNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Authorizable next() {
            Authorizable authr = this.next;
            if (authr == null) {
                throw new NoSuchElementException();
            }
            this.next = this.seekNext();
            return authr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seekNext() {
            while (this.authNodeIter.hasNext()) {
                NodeImpl node = (NodeImpl)this.authNodeIter.nextNode();
                try {
                    if (this.served.contains(node.getUUID())) continue;
                    Authorizable authr = UserManagerImpl.this.getAuthorizable(node);
                    this.served.add(node.getUUID());
                    if (authr == null) continue;
                    return authr;
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

