/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.sling.jcr.jackrabbit.server.impl.AbstractRegistrationSupport;

public class JndiRegistrationSupport
extends AbstractRegistrationSupport {
    private Context jndiContext;

    protected boolean doActivate() {
        Dictionary props = this.getComponentContext().getProperties();
        Properties env = new Properties();
        Enumeration pe = props.keys();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith("java.naming.")) continue;
            env.setProperty(key, (String)props.get(key));
        }
        try {
            this.jndiContext = this.createInitialContext(env);
            this.log(3, "Using JNDI context " + this.jndiContext.getEnvironment() + " to register repositories", null);
            return true;
        }
        catch (NamingException ne) {
            this.log(1, "Problem setting up JNDI initial context, repositories will not be registered. Reason: " + ne.getMessage(), null);
            return false;
        }
    }

    protected void doDeactivate() {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException ne) {
                this.log(3, "Problem closing JNDI context", ne);
            }
            this.jndiContext = null;
        }
    }

    private Context createInitialContext(final Properties env) throws NamingException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Context>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Context run() throws NamingException {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader old = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(JndiRegistrationSupport.this.getClass().getClassLoader());
                    try {
                        InitialContext initialContext = new InitialContext(env);
                        return initialContext;
                    }
                    finally {
                        currentThread.setContextClassLoader(old);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (NamingException)pae.getCause();
        }
    }

    protected Object bindRepository(String name, Repository repository) {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.bind(name, (Object)repository);
                this.log(3, "Repository bound to JNDI as " + name, null);
                return repository;
            }
            catch (NamingException ne) {
                this.log(1, "Failed to register repository " + name, ne);
            }
        }
        return null;
    }

    protected void unbindRepository(String name, Object data) {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.unbind(name);
                this.log(3, "Repository " + name + " unbound from JNDI", null);
            }
            catch (NamingException ne) {
                this.log(1, "Problem unregistering repository " + name, ne);
            }
        }
    }
}

