/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.jcr.Repository;
import org.apache.jackrabbit.rmi.jackrabbit.JackrabbitServerAdapterFactory;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.sling.jcr.jackrabbit.server.impl.AbstractRegistrationSupport;

public class RmiRegistrationSupport
extends AbstractRegistrationSupport {
    public static final String PROP_REGISTRY_PORT = "port";
    private int registryPort;
    private Registry registry;
    private boolean registryIsPrivate;

    protected boolean doActivate() {
        Object portProp = this.getComponentContext().getProperties().get(PROP_REGISTRY_PORT);
        int n = this.registryPort = portProp instanceof Number ? ((Number)portProp).intValue() : 0;
        if (this.registryPort < 0) {
            this.log(2, "RMI registry disabled (no or negative RMI port configured)", null);
            return false;
        }
        if (this.registryPort == 0) {
            this.registryPort = 1099;
        } else if (this.registryPort == 0 || this.registryPort > 65535) {
            this.log(2, "Illegal RMI registry port number " + this.registryPort + ", disabling RMI registry", null);
            return false;
        }
        this.log(3, "Using RMI Registry port " + this.registryPort, null);
        return true;
    }

    protected void doDeactivate() {
        if (this.registry != null && this.registryIsPrivate) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                this.log(3, "Unexported private RMI Registry at " + this.registryPort, null);
            }
            catch (NoSuchObjectException nsoe) {
                this.log(3, "Cannot unexport private RMI Registry reference", nsoe);
            }
        }
        this.registry = null;
    }

    protected Object bindRepository(String name, Repository repository) {
        return new RmiRegistration(name, repository);
    }

    protected void unbindRepository(String name, Object data) {
        RmiRegistration rr = (RmiRegistration)data;
        rr.unregister();
    }

    private Registry getPrivateRegistry() {
        if (this.registry == null) {
            try {
                this.registry = LocateRegistry.createRegistry(this.registryPort);
                this.registryIsPrivate = true;
                this.log(3, "Using private RMI Registry at " + this.registryPort, null);
            }
            catch (RemoteException re) {
                this.log(3, "Cannot create private registry, trying existing registry at " + this.registryPort + ", reason: " + re.toString(), null);
                try {
                    this.registry = LocateRegistry.getRegistry(this.registryPort);
                    this.registryIsPrivate = false;
                    this.log(3, "Trying existing registry at " + this.registryPort, null);
                }
                catch (RemoteException pre) {
                    this.log(1, "Cannot get existing registry, will not register repositories on RMI", pre);
                }
            }
        }
        return this.registry;
    }

    protected RemoteAdapterFactory getRemoteAdapterFactory() {
        return new JackrabbitServerAdapterFactory();
    }

    private class RmiRegistration {
        private String rmiName;
        private Remote rmiRepository;

        RmiRegistration(String rmiName, Repository repository) {
            this.register(rmiName, repository);
        }

        public String getRmiName() {
            return this.rmiName;
        }

        public String getRmiURL() {
            String host;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException ignore) {
                host = "localhost";
            }
            return "//" + host + ":" + RmiRegistrationSupport.this.registryPort + "/" + this.getRmiName();
        }

        private void register(String rmiName, Repository repository) {
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            try {
                RemoteAdapterFactory raf = RmiRegistrationSupport.this.getRemoteAdapterFactory();
                this.rmiRepository = raf.getRemoteRepository(repository);
            }
            catch (RemoteException e) {
                RmiRegistrationSupport.this.log(1, "Unable to create remote repository.", e);
                return;
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.log(1, "Unable to create RMI repository. jcr-rmi.jar might be missing.", e);
                return;
            }
            try {
                Registry registry = RmiRegistrationSupport.this.getPrivateRegistry();
                if (registry != null) {
                    registry.bind(rmiName, this.rmiRepository);
                    this.rmiName = rmiName;
                    RmiRegistrationSupport.this.log(3, "Repository bound to " + this.getRmiURL(), null);
                }
            }
            catch (NoSuchObjectException nsoe) {
                RmiRegistrationSupport.this.log(2, "Cannot contact RMI registry at " + RmiRegistrationSupport.this.registryPort + ", repository not registered", null);
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.log(1, "Unable to bind repository via RMI.", e);
            }
        }

        public void unregister() {
            if (this.rmiName != null) {
                try {
                    RmiRegistrationSupport.this.getPrivateRegistry().unbind(this.rmiName);
                    RmiRegistrationSupport.this.log(3, "Repository unbound from " + this.getRmiURL(), null);
                }
                catch (Exception e) {
                    RmiRegistrationSupport.this.log(1, "Error while unbinding repository from JNDI: " + e, null);
                }
            }
            if (this.rmiRepository != null) {
                try {
                    UnicastRemoteObject.unexportObject(this.rmiRepository, true);
                }
                catch (NoSuchObjectException nsoe) {
                    RmiRegistrationSupport.this.log(3, "Cannot unexport remote Repository reference", nsoe);
                }
            }
        }
    }
}

