/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNodeConverter
implements JcrInstaller.NodeConverter {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_DATA = "jcr:content/jcr:data";
    private static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    private static final String JCR_CONTENT_LAST_MODIFIED = "jcr:content/jcr:lastModified";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public InstallableResource convertNode(Node n, int priority) throws RepositoryException {
        String nodePath = n.getPath();
        if (n.hasProperty(JCR_CONTENT_DATA) && n.hasProperty(JCR_CONTENT_LAST_MODIFIED)) {
            try {
                return this.convert(n, nodePath, priority);
            }
            catch (IOException ioe) {
                this.logger.info("Conversion failed, node {} ignored ({})", (Object)nodePath, (Object)ioe);
            }
        } else {
            this.logger.debug("Node {} has no {} properties, ignored", (Object)nodePath, (Object)"jcr:content/jcr:data or jcr:content/jcr:lastModified");
        }
        return null;
    }

    private InstallableResource convert(Node n, String path, int priority) throws IOException, RepositoryException {
        String digest = String.valueOf(n.getProperty(JCR_CONTENT_LAST_MODIFIED).getDate().getTimeInMillis());
        InputStream is = n.getProperty(JCR_CONTENT_DATA).getStream();
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("installation.hint", n.getParent().getName());
        return new InstallableResource(path, is, dict, digest, null, Integer.valueOf(priority));
    }
}

