/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchedFolder
implements EventListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String path;
    private final int priority;
    private final Session session;
    private final Collection<JcrInstaller.NodeConverter> converters;
    private final Set<String> existingResourceUrls = new HashSet<String>();
    private volatile boolean needsScan;
    private final Map<String, String> digests = new HashMap<String, String>();

    WatchedFolder(Session session, String path, int priority, Collection<JcrInstaller.NodeConverter> converters) throws RepositoryException {
        if (priority < 1) {
            throw new IllegalArgumentException("Cannot watch folder with priority 0:" + path);
        }
        this.path = path;
        this.converters = converters;
        this.priority = priority;
        this.session = session;
    }

    public void start() throws RepositoryException {
        int eventTypes = 31;
        boolean isDeep = true;
        boolean noLocal = true;
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.path, true, null, null, true);
        this.needsScan = true;
        this.log.info("Watching folder {} (priority {})", (Object)this.path, (Object)this.priority);
    }

    public void stop() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException re) {
            this.log.warn("RepositoryException in cleanup()", (Throwable)re);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public void onEvent(EventIterator it) {
        this.log.debug("JCR events received for path {}", (Object)this.path);
        this.needsScan = true;
    }

    public boolean needsScan() {
        return this.needsScan;
    }

    public ScanResult scan() throws RepositoryException {
        Item i;
        this.log.debug("Scanning {}", (Object)this.path);
        this.needsScan = false;
        Node folder = null;
        if (this.session.itemExists(this.path) && (i = this.session.getItem(this.path)).isNode()) {
            folder = (Node)i;
        }
        ScanResult result = new ScanResult();
        HashSet<String> resourcesSeen = new HashSet<String>();
        if (folder != null) {
            this.scanNode(folder, result, resourcesSeen);
        }
        for (String url : this.existingResourceUrls) {
            if (resourcesSeen.contains(url)) continue;
            result.toRemove.add(url);
        }
        for (String u : result.toRemove) {
            this.existingResourceUrls.remove(u);
            this.digests.remove(u);
        }
        for (InstallableResource r : result.toAdd) {
            this.existingResourceUrls.add(r.getId());
            this.digests.put(r.getId(), r.getDigest());
        }
        return result;
    }

    private void scanNode(Node folder, ScanResult result, Set<String> resourcesSeen) throws RepositoryException {
        NodeIterator it = folder.getNodes();
        while (it.hasNext()) {
            Node n = it.nextNode();
            boolean processed = false;
            for (JcrInstaller.NodeConverter nc : this.converters) {
                InstallableResource r = nc.convertNode(n, this.priority);
                if (r == null) continue;
                processed = true;
                resourcesSeen.add(r.getId());
                String oldDigest = this.digests.get(r.getId());
                if (r.getDigest().equals(oldDigest)) {
                    this.log.debug("Digest didn't change, ignoring " + r);
                    break;
                }
                result.toAdd.add(r);
                break;
            }
            if (processed) continue;
            this.scanNode(n, result, resourcesSeen);
        }
    }

    static class ScanResult {
        List<InstallableResource> toAdd = new ArrayList<InstallableResource>();
        List<String> toRemove = new ArrayList<String>();

        ScanResult() {
        }
    }
}

