/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigNodeConverter
implements JcrInstaller.NodeConverter {
    public static final String CONFIG_NODE_TYPE = "sling:OsgiConfig";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    ConfigNodeConverter() {
    }

    @Override
    public InstallableResource convertNode(Node n, int priority) throws RepositoryException {
        InstallableResource result = null;
        if (n.isNodeType(CONFIG_NODE_TYPE)) {
            Dictionary<String, Object> dict = this.load(n);
            result = new InstallableResource(n.getPath(), null, dict, ConfigNodeConverter.computeDigest(dict), null, Integer.valueOf(priority));
            this.log.debug("Converted node {} to {}", (Object)n.getPath(), (Object)result);
        } else {
            this.log.debug("Node is not a {} node, ignored:{}", (Object)CONFIG_NODE_TYPE, (Object)n.getPath());
        }
        return result;
    }

    protected Dictionary<String, Object> load(Node n) throws RepositoryException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.log.debug("Loading config from Node {}", (Object)n.getPath());
        this.log.debug("Loading {} properties", (Object)n.getPath());
        this.loadProperties(result, n);
        return result;
    }

    protected void loadProperties(Dictionary<String, Object> d, Node n) throws RepositoryException {
        PropertyIterator pi = n.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            String name = p.getName();
            if (name.contains(":")) continue;
            if (p.getDefinition().isMultiple()) {
                Object[] data = null;
                Value[] values = p.getValues();
                int i = 0;
                for (Value v : values) {
                    Object o = this.convertValue(v);
                    if (i == 0) {
                        data = (Object[])Array.newInstance(o.getClass(), values.length);
                    }
                    data[i++] = o;
                }
                if (data == null) {
                    data = new String[]{};
                }
                d.put(name, data);
                continue;
            }
            Object o = this.convertValue(p.getValue());
            if (o == null) continue;
            d.put(name, o);
        }
    }

    protected Object convertValue(Value v) throws RepositoryException {
        switch (v.getType()) {
            case 1: {
                return v.getString();
            }
            case 5: {
                return v.getDate();
            }
            case 4: {
                return v.getDouble();
            }
            case 3: {
                return v.getLong();
            }
            case 6: {
                return v.getBoolean();
            }
        }
        this.log.debug("Value of type {} ignored", (Object)v.getType());
        return null;
    }

    private static String digestToString(MessageDigest d) {
        BigInteger bigInt = new BigInteger(1, d.digest());
        return new String(bigInt.toString(16));
    }

    private static String computeDigest(Dictionary<String, Object> data) {
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            TreeSet<String> sortedKeys = new TreeSet<String>();
            if (data != null) {
                Enumeration<String> e = data.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    sortedKeys.add(key);
                }
            }
            for (String key : sortedKeys) {
                oos.writeObject(key);
                oos.writeObject(data.get(key));
            }
            bos.flush();
            d.update(bos.toByteArray());
            return ConfigNodeConverter.digestToString(d);
        }
        catch (Exception ignore) {
            return data.toString();
        }
    }
}

