/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchedFolder
implements EventListener {
    private final String path;
    private final int priority;
    private final Session session;
    private static RescanTimer rescanTimer = new RescanTimer();
    private boolean needsScan;
    private final Collection<JcrInstaller.NodeConverter> converters;
    private final Set<String> existingResourceUrls = new HashSet<String>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> digests = new HashMap<String, String>();

    WatchedFolder(Session session, String path, int priority, Collection<JcrInstaller.NodeConverter> converters) throws RepositoryException {
        if (priority < 1) {
            throw new IllegalArgumentException("Cannot watch folder with priority 0:" + path);
        }
        this.path = path;
        this.converters = converters;
        this.priority = priority;
        this.session = session;
        int eventTypes = 31;
        boolean isDeep = true;
        boolean noLocal = true;
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, path, true, null, null, true);
        this.log.info("Watching folder {} (priority {})", (Object)path, (Object)priority);
    }

    void cleanup() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException re) {
            this.log.warn("RepositoryException in cleanup()", (Throwable)re);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.path;
    }

    String getPath() {
        return this.path;
    }

    public void onEvent(EventIterator it) {
        this.log.debug("JCR event received for path {}", (Object)this.path);
        this.scheduleScan();
    }

    void scheduleScan() {
        this.log.debug("Scheduling scan of {}", (Object)this.path);
        rescanTimer.scheduleScan();
        this.needsScan = true;
    }

    boolean needsScan() {
        return this.needsScan;
    }

    static RescanTimer getRescanTimer() {
        return rescanTimer;
    }

    ScanResult scan() throws RepositoryException {
        Item i;
        this.log.debug("Scanning {}", (Object)this.path);
        this.needsScan = false;
        Node folder = null;
        if (this.session.itemExists(this.path) && (i = this.session.getItem(this.path)).isNode()) {
            folder = (Node)i;
        }
        ScanResult result = new ScanResult();
        HashSet<String> resourcesSeen = new HashSet<String>();
        if (folder != null) {
            NodeIterator it = folder.getNodes();
            block0: while (it.hasNext()) {
                Node n = it.nextNode();
                for (JcrInstaller.NodeConverter nc : this.converters) {
                    InstallableResource r = nc.convertNode(n, this.priority);
                    if (r == null) continue;
                    resourcesSeen.add(r.getId());
                    String oldDigest = this.digests.get(r.getId());
                    if (r.getDigest().equals(oldDigest)) {
                        this.log.debug("Digest didn't change, ignoring " + r);
                        continue block0;
                    }
                    result.toAdd.add(r);
                    continue block0;
                }
            }
        }
        for (String url : this.existingResourceUrls) {
            if (resourcesSeen.contains(url)) continue;
            result.toRemove.add(url);
        }
        for (String u : result.toRemove) {
            this.existingResourceUrls.remove(u);
            this.digests.remove(u);
        }
        for (InstallableResource r : result.toAdd) {
            this.existingResourceUrls.add(r.getId());
            this.digests.put(r.getId(), r.getDigest());
        }
        return result;
    }

    static class ScanResult {
        List<InstallableResource> toAdd = new ArrayList<InstallableResource>();
        List<String> toRemove = new ArrayList<String>();

        ScanResult() {
        }
    }
}

