/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.provider.jcr.impl.ConfigNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FileNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FolderNameFilter;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.apache.sling.installer.provider.jcr.impl.RootFolderListener;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrInstaller
implements EventListener {
    public static final long RUN_LOOP_DELAY_MSEC = 500L;
    public static final String URL_SCHEME = "jcrinstall";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long[] counters = new long[3];
    public static final int SCAN_FOLDERS_COUNTER = 0;
    public static final int UPDATE_FOLDERS_LIST_COUNTER = 1;
    public static final int RUN_LOOP_COUNTER = 2;
    public static final int COUNTERS_COUNT = 3;
    private SlingRepository repository;
    private SlingSettingsService settings;
    private OsgiInstaller installer;
    public static final String DEFAULT_FOLDER_NAME_REGEXP = ".*/install$";
    public static final String FOLDER_NAME_REGEXP_PROPERTY = "sling.jcrinstall.folder.name.regexp";
    public static final String PROP_INSTALL_FOLDER_MAX_DEPTH = "sling.jcrinstall.folder.max.depth";
    public static final String PROP_SEARCH_PATH = "sling.jcrinstall.search.path";
    public static final String[] DEFAULT_SEARCH_PATH = new String[]{"/libs:100", "/apps:200"};
    public static final int DEFAULT_FOLDER_MAX_DEPTH = 4;
    private int maxWatchedFolderDepth;
    private FolderNameFilter folderNameFilter;
    private List<WatchedFolder> watchedFolders;
    private Session session;
    private String[] roots;
    private ComponentContext componentContext;
    private final Collection<NodeConverter> converters = new ArrayList<NodeConverter>();
    private final List<RootFolderListener> listeners = new LinkedList<RootFolderListener>();
    private final RescanTimer updateFoldersListTimer = new RescanTimer();
    static int bgThreadCounter;
    private StoppableThread backgroundThread;

    protected void activate(ComponentContext context) {
        if (this.backgroundThread != null) {
            throw new IllegalStateException("Expected backgroundThread to be null in activate()");
        }
        this.componentContext = context;
        this.log.info("Activating Apache Sling JCR Installer");
        this.converters.add(new FileNodeConverter());
        this.converters.add(new ConfigNodeConverter());
        Object obj = this.getPropertyValue(context, PROP_INSTALL_FOLDER_MAX_DEPTH);
        if (obj != null) {
            this.maxWatchedFolderDepth = Integer.valueOf(String.valueOf(obj));
            this.log.debug("Using configured ({}) folder name max depth '{}'", (Object)PROP_INSTALL_FOLDER_MAX_DEPTH, (Object)this.maxWatchedFolderDepth);
        } else {
            this.maxWatchedFolderDepth = 4;
            this.log.debug("Using default folder max depth {}, not provided by {}", (Object)this.maxWatchedFolderDepth, (Object)PROP_INSTALL_FOLDER_MAX_DEPTH);
        }
        String folderNameRegexp = (String)this.getPropertyValue(context, FOLDER_NAME_REGEXP_PROPERTY);
        if (folderNameRegexp != null) {
            folderNameRegexp = folderNameRegexp.trim();
            this.log.debug("Using configured ({}) folder name regexp '{}'", (Object)FOLDER_NAME_REGEXP_PROPERTY, (Object)folderNameRegexp);
        } else {
            folderNameRegexp = DEFAULT_FOLDER_NAME_REGEXP;
            this.log.debug("Using default folder name regexp '{}', not provided by {}", (Object)folderNameRegexp, (Object)FOLDER_NAME_REGEXP_PROPERTY);
        }
        this.folderNameFilter = new FolderNameFilter(OsgiUtil.toStringArray(context.getProperties().get(PROP_SEARCH_PATH), (String[])DEFAULT_SEARCH_PATH), folderNameRegexp, this.settings.getRunModes());
        this.roots = this.folderNameFilter.getRootPaths();
        this.backgroundThread = new StoppableThread();
        this.backgroundThread.start();
    }

    protected void deactivate(ComponentContext context) {
        this.log.info("Deactivating Apache Sling JCR Installer");
        long timeout = 30000L;
        this.backgroundThread.active = false;
        this.log.debug("Waiting for " + this.backgroundThread.getName() + " Thread to end...");
        this.backgroundThread.interrupt();
        try {
            this.backgroundThread.join(30000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        this.backgroundThread = null;
        this.folderNameFilter = null;
        this.watchedFolders = null;
        this.converters.clear();
        try {
            if (this.session != null) {
                for (RootFolderListener wfc : this.listeners) {
                    wfc.cleanup(this.session);
                }
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Exception in deactivate()", (Throwable)e);
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.listeners.clear();
        this.componentContext = null;
    }

    protected Object getPropertyValue(ComponentContext ctx, String name) {
        String result = ctx.getBundleContext().getProperty(name);
        if (result == null) {
            result = ctx.getProperties().get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findPathsToWatch(String rootPath, List<WatchedFolder> result) throws RepositoryException {
        Session s = null;
        try {
            s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            if (!s.itemExists(rootPath) || !s.getItem(rootPath).isNode()) {
                this.log.info("Bundles root node {} not found, ignored", (Object)rootPath);
            } else {
                this.log.debug("Bundles root node {} found, looking for bundle folders inside it", (Object)rootPath);
                Node n = (Node)s.getItem(rootPath);
                this.findPathsUnderNode(n, result);
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    void findPathsUnderNode(Node n, List<WatchedFolder> result) throws RepositoryException {
        int depth;
        String path = n.getPath();
        int priority = this.folderNameFilter.getPriority(path);
        if (priority > 0) {
            result.add(new WatchedFolder(this.session, path, priority, this.converters));
        }
        if ((depth = path.split("/").length) > this.maxWatchedFolderDepth) {
            this.log.debug("Not recursing into {} due to maxWatchedFolderDepth={}", (Object)path, (Object)this.maxWatchedFolderDepth);
            return;
        }
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            this.findPathsUnderNode(it.nextNode(), result);
        }
    }

    private void addWatchedFolder(WatchedFolder toAdd) {
        WatchedFolder existing = null;
        for (WatchedFolder wf : this.watchedFolders) {
            if (!wf.getPath().equals(toAdd.getPath())) continue;
            existing = wf;
            break;
        }
        if (existing == null) {
            this.watchedFolders.add(toAdd);
            toAdd.scheduleScan();
        } else {
            toAdd.cleanup();
        }
    }

    private List<String> updateFoldersList() throws Exception {
        this.log.debug("Updating folder list.");
        LinkedList<String> result = new LinkedList<String>();
        ArrayList<WatchedFolder> newFolders = new ArrayList<WatchedFolder>();
        for (String root : this.roots) {
            this.findPathsToWatch(root, newFolders);
        }
        for (WatchedFolder wf : newFolders) {
            this.addWatchedFolder(wf);
        }
        ArrayList<WatchedFolder> toRemove = new ArrayList<WatchedFolder>();
        for (WatchedFolder wf : this.watchedFolders) {
            this.log.debug("Item {} exists? {}", (Object)wf.getPath(), (Object)this.session.itemExists(wf.getPath()));
            if (this.session.itemExists(wf.getPath())) continue;
            result.addAll(wf.scan().toRemove);
            wf.cleanup();
            toRemove.add(wf);
        }
        for (WatchedFolder wf : toRemove) {
            this.log.info("Deleting {}, path does not exist anymore", (Object)wf);
            this.watchedFolders.remove(wf);
        }
        return result;
    }

    public void onEvent(EventIterator it) {
        try {
            while (it.hasNext()) {
                Event e = it.nextEvent();
                this.log.debug("Got event {}", (Object)e);
                for (String root : this.roots) {
                    if (!e.getPath().startsWith(root)) continue;
                    this.log.info("Got event for root {}, scheduling scanning of new folders", (Object)root);
                    this.updateFoldersListTimer.scheduleScan();
                }
            }
        }
        catch (RepositoryException re) {
            this.log.warn("RepositoryException in onEvent", (Throwable)re);
        }
    }

    public void runOneCycle() {
        this.log.debug("Running watch cycle.");
        try {
            boolean didRefresh = true;
            boolean scanWf = WatchedFolder.getRescanTimer().expired();
            if (scanWf) {
                this.session.refresh(false);
                didRefresh = true;
                for (WatchedFolder wf : this.watchedFolders) {
                    if (!wf.needsScan()) continue;
                    WatchedFolder.getRescanTimer().reset();
                    this.counters[0] = this.counters[0] + 1L;
                    WatchedFolder.ScanResult sr = wf.scan();
                    this.log.info("Registering resource with OSGi installer: {}", sr.toAdd);
                    this.log.info("Removing resource from OSGi installer: {}", sr.toRemove);
                    this.installer.updateResources(URL_SCHEME, sr.toAdd.toArray(new InstallableResource[sr.toAdd.size()]), sr.toRemove.toArray(new String[sr.toRemove.size()]));
                }
            }
            if (scanWf || this.updateFoldersListTimer.expired()) {
                if (!didRefresh) {
                    this.session.refresh(false);
                    didRefresh = true;
                }
                this.updateFoldersListTimer.reset();
                this.counters[1] = this.counters[1] + 1L;
                List<String> toRemove = this.updateFoldersList();
                this.log.info("Removing resource from OSGi installer (folder deleted): {}", toRemove);
                this.installer.updateResources(URL_SCHEME, null, toRemove.toArray(new String[toRemove.size()]));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            this.log.warn("Exception in run()", (Throwable)e);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.counters[2] = this.counters[2] + 1L;
    }

    long[] getCounters() {
        return this.counters;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindInstaller(OsgiInstaller osgiInstaller) {
        this.installer = osgiInstaller;
    }

    protected void unbindInstaller(OsgiInstaller osgiInstaller) {
        if (this.installer == osgiInstaller) {
            this.installer = null;
        }
    }

    class StoppableThread
    extends Thread {
        boolean active = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoppableThread() {
            Class<JcrInstaller> clazz = JcrInstaller.class;
            synchronized (JcrInstaller.class) {
                this.setName("JcrInstaller." + ++bgThreadCounter);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.setDaemon(true);
                return;
            }
        }

        public final void run() {
            block6: {
                JcrInstaller.this.log.info("Background thread {} starting", (Object)Thread.currentThread().getName());
                try {
                    JcrInstaller.this.session = JcrInstaller.this.repository.loginAdministrative(JcrInstaller.this.repository.getDefaultWorkspace());
                    for (String path : JcrInstaller.this.roots) {
                        JcrInstaller.this.listeners.add(new RootFolderListener(JcrInstaller.this.session, JcrInstaller.this.folderNameFilter, path, JcrInstaller.this.updateFoldersListTimer));
                        JcrInstaller.this.log.debug("Configured root folder: {}", (Object)path);
                    }
                    JcrInstaller.this.session.getWorkspace().getObservationManager().addEventListener((EventListener)JcrInstaller.this, 3, "/", false, null, null, true);
                    JcrInstaller.this.log.debug("Watching for node events on / to detect removal/add of our root folders");
                    JcrInstaller.this.watchedFolders = new LinkedList();
                    for (String root : JcrInstaller.this.roots) {
                        JcrInstaller.this.findPathsToWatch(root, JcrInstaller.this.watchedFolders);
                    }
                    LinkedList<InstallableResource> resources = new LinkedList<InstallableResource>();
                    for (WatchedFolder f : JcrInstaller.this.watchedFolders) {
                        WatchedFolder.ScanResult r = f.scan();
                        JcrInstaller.this.log.debug("Startup: {} provides resources {}", (Object)f, r.toAdd);
                        resources.addAll(r.toAdd);
                    }
                    JcrInstaller.this.log.debug("Registering {} resources with OSGi installer: {}", (Object)resources.size(), resources);
                    JcrInstaller.this.installer.registerResources(JcrInstaller.URL_SCHEME, resources.toArray(new InstallableResource[resources.size()]));
                }
                catch (RepositoryException re) {
                    JcrInstaller.this.log.error("Repository exception during startup - deactivating installer!", (Throwable)re);
                    this.active = false;
                    ComponentContext ctx = JcrInstaller.this.componentContext;
                    if (ctx == null) break block6;
                    String name = (String)JcrInstaller.this.componentContext.getProperties().get("component.name");
                    ctx.disableComponent(name);
                }
            }
            while (this.active) {
                JcrInstaller.this.runOneCycle();
            }
            JcrInstaller.this.log.info("Background thread {} done", (Object)Thread.currentThread().getName());
            ((JcrInstaller)JcrInstaller.this).counters[2] = -1L;
        }
    }

    static interface NodeConverter {
        public InstallableResource convertNode(Node var1, int var2) throws RepositoryException;
    }
}

