/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.i18n.impl.ResourceBundleEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceBundle
extends ResourceBundle {
    private static final Logger log = LoggerFactory.getLogger(JcrResourceBundle.class);
    static final String JCR_PATH = "jcr:path";
    static final String PROP_KEY = "sling:key";
    static final String PROP_VALUE = "sling:message";
    static final String PROP_BASENAME = "sling:basename";
    static final String PROP_LANGUAGE = "jcr:language";
    private static final String QUERY_MESSAGES_FORMAT = "/jcr:root%s//element(*,sling:Message)";
    private final Map<String, Object> resources;
    private final Locale locale;
    private final Set<String> languageRoots = new HashSet<String>();

    JcrResourceBundle(Locale locale, String baseName, ResourceResolver resourceResolver) {
        this.locale = locale;
        long start = System.currentTimeMillis();
        JcrResourceBundle.refreshSession(resourceResolver, true);
        Set<String> roots = this.loadPotentialLanguageRoots(resourceResolver, locale, baseName);
        this.resources = this.loadFully(resourceResolver, roots, this.languageRoots);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("JcrResourceBundle: Fully loaded {} entries for {} (base: {}) in {}ms", new Object[]{this.resources.size(), locale, baseName, end - start});
            log.debug("JcrResourceBundle: Language roots: {}", this.languageRoots);
        }
    }

    static void refreshSession(ResourceResolver resolver, boolean keepChanges) {
        Session s = (Session)resolver.adaptTo(Session.class);
        if (s == null) {
            log.warn("ResourceResolver {} does not adapt to Session, cannot refresh", (Object)resolver);
        } else {
            try {
                s.refresh(keepChanges);
            }
            catch (RepositoryException re) {
                throw new RuntimeException("RepositoryException in session.refresh", re);
            }
        }
    }

    protected Set<String> getLanguageRootPaths() {
        return this.languageRoots;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> parentKeys = this.parent != null ? this.parent.getKeys() : null;
        return new ResourceBundleEnumeration(this.resources.keySet(), parentKeys);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.resources.get(key);
    }

    private Map<String, Object> loadFully(ResourceResolver resourceResolver, Set<String> roots, Set<String> languageRoots) {
        HashMap<String, Object> rest = new HashMap<String, Object>();
        for (String root : roots) {
            int i;
            String fullLoadQuery = String.format(QUERY_MESSAGES_FORMAT, ISO9075.encodePath((String)root));
            log.debug("Executing full load query {}", (Object)fullLoadQuery);
            Iterator bundles = null;
            try {
                bundles = resourceResolver.queryResources(fullLoadQuery, "xpath");
            }
            catch (SlingException se) {
                log.error("Exception during resource query " + fullLoadQuery, (Throwable)se);
            }
            if (bundles == null) continue;
            String[] path = resourceResolver.getSearchPath();
            ArrayList res0 = new ArrayList();
            for (i = 0; i < path.length; ++i) {
                res0.add(new HashMap());
            }
            while (bundles.hasNext()) {
                Map row = (Map)bundles.next();
                if (!row.containsKey(PROP_VALUE)) continue;
                String jcrPath = (String)row.get(JCR_PATH);
                String key = (String)row.get(PROP_KEY);
                if (key == null) {
                    key = ResourceUtil.getName((String)jcrPath);
                }
                Map<String, Object> dst = rest;
                for (int i2 = 0; i2 < path.length; ++i2) {
                    if (!jcrPath.startsWith(path[i2])) continue;
                    dst = (Map)res0.get(i2);
                    break;
                }
                dst.put(key, row.get(PROP_VALUE));
            }
            for (i = path.length - 1; i >= 0; --i) {
                Map resources = (Map)res0.get(i);
                if (resources.isEmpty()) continue;
                rest.putAll(resources);
                languageRoots.add(root);
            }
        }
        return rest;
    }

    private Set<String> loadPotentialLanguageRoots(ResourceResolver resourceResolver, Locale locale, String baseName) {
        String localeString = locale.toString();
        String localeStringLower = localeString.toLowerCase();
        String localeRFC4646String = JcrResourceBundle.toRFC4646String(locale);
        String localeRFC4646StringLower = localeRFC4646String.toLowerCase();
        HashSet<String> paths = new HashSet<String>();
        Iterator bundles = resourceResolver.findResources("//element(*,mix:language)", "xpath");
        while (bundles.hasNext()) {
            Resource bundle = (Resource)bundles.next();
            ValueMap properties = (ValueMap)bundle.adaptTo(ValueMap.class);
            String language = (String)properties.get(PROP_LANGUAGE, String.class);
            if (language == null || language.length() <= 0 || !language.equals(localeString) && !language.equals(localeStringLower) && !language.equals(localeRFC4646String) && !language.equals(localeRFC4646StringLower) || baseName != null && !baseName.equals(properties.get(PROP_BASENAME, (Object)""))) continue;
            paths.add(bundle.getPath());
        }
        return Collections.unmodifiableSet(paths);
    }

    private static String toRFC4646String(Locale locale) {
        return locale.toString().replace('_', '-');
    }
}

