/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.i18n.DefaultLocaleResolver;
import org.apache.sling.i18n.LocaleResolver;
import org.apache.sling.i18n.RequestLocaleResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SlingFilter(generateComponent=false, generateService=true, order=-700, scope={SlingFilterScope.REQUEST, SlingFilterScope.ERROR})
@Component(immediate=true, metatype=false, specVersion="1.2")
@Properties(value={@Property(name="pattern", value={"/.*"}), @Property(name="service.description", value={"Internationalization Support Filter"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class I18NFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger((String)I18NFilter.class.getName());
    private final DefaultLocaleResolver DEFAULT_LOCALE_RESOLVER = new DefaultLocaleResolver();
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private LocaleResolver localeResolver = this.DEFAULT_LOCALE_RESOLVER;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private RequestLocaleResolver requestLocaleResolver = this.DEFAULT_LOCALE_RESOLVER;
    @Reference(name="resourceBundleProvider", referenceInterface=ResourceBundleProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<Object, ResourceBundleProvider> providers = new TreeMap<Object, ResourceBundleProvider>();
    private volatile ResourceBundleProvider[] sortedProviders = new ResourceBundleProvider[0];
    private final ResourceBundleProvider combinedProvider = new CombinedBundleProvider();
    private volatile int initCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) {
        I18NFilter i18NFilter = this;
        synchronized (i18NFilter) {
            ++this.initCount;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean runGlobal;
        boolean bl = runGlobal = this.initCount == 2;
        request = request instanceof SlingHttpServletRequest ? (!runGlobal || this.requestLocaleResolver == this.DEFAULT_LOCALE_RESOLVER ? new I18NSlingHttpServletRequest((ServletRequest)request, this.combinedProvider, this.localeResolver) : new BaseI18NSlingHttpServletRequest((ServletRequest)request, this.combinedProvider)) : new I18NHttpServletRequest((ServletRequest)request, this.combinedProvider, this.requestLocaleResolver);
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        I18NFilter i18NFilter = this;
        synchronized (i18NFilter) {
            --this.initCount;
        }
    }

    protected void bindLocaleResolver(LocaleResolver resolver) {
        this.localeResolver = resolver;
    }

    protected void unbindLocaleResolver(LocaleResolver resolver) {
        if (this.localeResolver == resolver) {
            this.localeResolver = this.DEFAULT_LOCALE_RESOLVER;
        }
    }

    protected void bindRequestLocaleResolver(RequestLocaleResolver resolver) {
        this.requestLocaleResolver = resolver;
    }

    protected void unbindRequestLocaleResolver(RequestLocaleResolver resolver) {
        if (this.requestLocaleResolver == resolver) {
            this.requestLocaleResolver = this.DEFAULT_LOCALE_RESOLVER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.put(ServiceUtil.getComparableForServiceRanking(props), provider);
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.remove(ServiceUtil.getComparableForServiceRanking(props));
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class I18NSlingHttpServletRequest
    extends BaseI18NSlingHttpServletRequest {
        private final LocaleResolver localeResolver;
        private Locale locale;
        private List<Locale> localeList;

        I18NSlingHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider, LocaleResolver localeResolver) {
            super(delegatee, bundleProvider);
            this.localeResolver = localeResolver;
        }

        public Object getAttribute(String name) {
            if ("org.apache.sling.i18n.resourcebundle".equals(name)) {
                Object superValue = super.getAttribute(name);
                return superValue != null ? superValue : this.getResourceBundle(null);
            }
            return super.getAttribute(name);
        }

        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = this.getLocaleList().get(0);
            }
            return this.locale;
        }

        public Enumeration<?> getLocales() {
            return Collections.enumeration(this.getLocaleList());
        }

        private List<Locale> getLocaleList() {
            if (this.localeList == null) {
                List<Locale> resolved = this.localeResolver.resolveLocale(this.getSlingRequest());
                this.localeList = resolved != null && !resolved.isEmpty() ? resolved : Collections.singletonList(this.bundleProvider.getDefaultLocale());
            }
            return this.localeList;
        }
    }

    private static class BaseI18NSlingHttpServletRequest
    extends SlingHttpServletRequestWrapper {
        protected final ResourceBundleProvider bundleProvider;

        BaseI18NSlingHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider) {
            super((SlingHttpServletRequest)delegatee);
            this.bundleProvider = bundleProvider;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.getResourceBundle(null, locale);
        }

        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            if (this.bundleProvider != null) {
                if (locale == null) {
                    locale = this.getLocale();
                }
                try {
                    return this.bundleProvider.getResourceBundle(baseName, locale);
                }
                catch (MissingResourceException mre) {
                    LOG.warn("getResourceBundle: Cannot get ResourceBundle from provider", (Throwable)mre);
                }
            } else {
                LOG.info("getResourceBundle: ResourceBundleProvider not available, calling default implementation");
            }
            return super.getResourceBundle(baseName, locale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class I18NHttpServletRequest
    extends HttpServletRequestWrapper {
        private final ResourceBundleProvider bundleProvider;
        private final RequestLocaleResolver localeResolver;
        private Locale locale;
        private List<Locale> localeList;
        private ResourceBundle resourceBundle;

        I18NHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider, RequestLocaleResolver localeResolver) {
            super((HttpServletRequest)delegatee);
            this.bundleProvider = bundleProvider;
            this.localeResolver = localeResolver;
        }

        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = this.getLocaleList().get(0);
            }
            return this.locale;
        }

        public Enumeration<?> getLocales() {
            return Collections.enumeration(this.getLocaleList());
        }

        public Object getAttribute(String name) {
            if ("org.apache.sling.i18n.resourcebundle".equals(name)) {
                if (this.resourceBundle == null && this.bundleProvider != null) {
                    this.resourceBundle = this.bundleProvider.getResourceBundle(this.getLocale());
                }
                return this.resourceBundle;
            }
            return super.getAttribute(name);
        }

        private List<Locale> getLocaleList() {
            if (this.localeList == null) {
                List<Locale> resolved = this.localeResolver.resolveLocale((HttpServletRequest)this.getRequest());
                this.localeList = resolved != null && !resolved.isEmpty() ? resolved : Collections.singletonList(this.bundleProvider.getDefaultLocale());
            }
            return this.localeList;
        }
    }

    private class CombinedBundleProvider
    implements ResourceBundleProvider {
        private CombinedBundleProvider() {
        }

        public Locale getDefaultLocale() {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                Locale locale = provider.getDefaultLocale();
                if (locale == null) continue;
                return locale;
            }
            return null;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                ResourceBundle bundle = provider.getResourceBundle(locale);
                if (bundle == null) continue;
                return bundle;
            }
            return null;
        }

        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                ResourceBundle bundle = provider.getResourceBundle(baseName, locale);
                if (bundle == null) continue;
                return bundle;
            }
            return null;
        }
    }
}

