/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.JcrResourceBundle;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceBundleProvider
implements ResourceBundleProvider,
EventListener {
    private static final String PROP_USER = "user";
    private static final String PROP_PASS = "password";
    private static final String PROP_DEFAULT_LOCALE = "locale.default";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private JcrResourceResolverFactory resourceResolverFactory;
    private Locale defaultLocale = Locale.ENGLISH;
    private Credentials repoCredentials;
    private ResourceResolver resourceResolver;
    private final Map<String, Map<Locale, ResourceBundle>> resourceBundleCache = new HashMap<String, Map<Locale, ResourceBundle>>();

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        return this.getResourceBundleInternal(baseName, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        this.log.debug("onEvent: Resource changes, removing cached ResourceBundles");
        Map<String, Map<Locale, ResourceBundle>> map = this.resourceBundleCache;
        synchronized (map) {
            this.resourceBundleCache.clear();
        }
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String user = (String)props.get(PROP_USER);
        if (user == null || user.length() == 0) {
            this.repoCredentials = null;
        } else {
            String pass = (String)props.get(PROP_PASS);
            char[] pwd = pass == null ? new char[]{} : pass.toCharArray();
            this.repoCredentials = new SimpleCredentials(user, pwd);
        }
        String localeString = (String)props.get(PROP_DEFAULT_LOCALE);
        this.defaultLocale = this.toLocale(localeString);
    }

    protected void bindRepository(SlingRepository repository) {
        if (this.repository != null) {
            this.releaseRepository();
        }
        this.repository = repository;
    }

    protected void unbindRepository(SlingRepository repository) {
        if (this.repository == repository) {
            this.releaseRepository();
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(JcrResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory != null) {
            this.releaseRepository();
        }
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(JcrResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.releaseRepository();
            this.resourceResolverFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleInternal(String baseName, Locale locale) {
        Map<Locale, ResourceBundle> appBundles;
        ResourceBundle resourceBundle = null;
        Map<String, Map<Locale, ResourceBundle>> map = this.resourceBundleCache;
        synchronized (map) {
            appBundles = this.resourceBundleCache.get(baseName);
            if (appBundles != null) {
                resourceBundle = appBundles.get(locale);
            }
        }
        if (resourceBundle == null) {
            resourceBundle = this.createResourceBundle(baseName, locale);
            map = this.resourceBundleCache;
            synchronized (map) {
                appBundles = this.resourceBundleCache.get(baseName);
                if (appBundles == null) {
                    appBundles = new HashMap<Locale, ResourceBundle>();
                    this.resourceBundleCache.put(baseName, appBundles);
                }
                if (appBundles.containsKey(locale)) {
                    resourceBundle = appBundles.get(locale);
                } else {
                    appBundles.put(locale, resourceBundle);
                }
            }
        }
        return resourceBundle;
    }

    private ResourceBundle createResourceBundle(String baseName, Locale locale) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            this.log.info("createResourceBundle: Missing Resource Resolver, cannot create Resource Bundle");
            throw new MissingResourceException("ResourceResolver not available", this.getClass().getName(), "");
        }
        JcrResourceBundle bundle = new JcrResourceBundle(locale, baseName, resolver);
        Locale parentLocale = this.getParentLocale(locale);
        if (parentLocale != null) {
            bundle.setParent(this.getResourceBundleInternal(baseName, parentLocale));
        }
        return bundle;
    }

    private Locale getParentLocale(Locale locale) {
        if (locale.getVariant().length() != 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() != 0) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.defaultLocale;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            SlingRepository repo = this.repository;
            JcrResourceResolverFactory fac = this.resourceResolverFactory;
            if (repo == null) {
                this.log.error("getResourceResolver: SlingRepository missing. Cannot login to create ResourceResolver");
            } else if (fac == null) {
                this.log.error("getResourceResolver: ResourceResolverFactory is missing. Cannot create ResourceResolver");
            } else {
                Session s = null;
                try {
                    s = this.repoCredentials == null ? repo.loginAdministrative(null) : repo.login(this.repoCredentials);
                    ObservationManager om = s.getWorkspace().getObservationManager();
                    om.addEventListener((EventListener)this, 255, "/", true, null, new String[]{"mix:language", "sling:Message"}, true);
                    this.resourceResolver = fac.getResourceResolver(s);
                }
                catch (RepositoryException re) {
                    this.log.error("getResourceResolver: Problem setting up ResourceResolver with Session", (Throwable)re);
                }
                finally {
                    if (this.resourceResolver == null && s != null) {
                        s.logout();
                    }
                }
            }
        }
        return this.resourceResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRepository() {
        Session s;
        ResourceResolver resolver = this.resourceResolver;
        this.resourceResolver = null;
        Map<String, Map<Locale, ResourceBundle>> map = this.resourceBundleCache;
        synchronized (map) {
            this.resourceBundleCache.clear();
        }
        if (resolver != null && (s = (Session)resolver.adaptTo(Session.class)) != null) {
            try {
                ObservationManager om = s.getWorkspace().getObservationManager();
                om.removeEventListener((EventListener)this);
            }
            catch (Throwable t) {
                this.log.info("releaseRepository: Problem unregistering as event listener", t);
            }
            try {
                s.logout();
            }
            catch (Throwable t) {
                this.log.info("releaseRepository: Unexpected problem logging out from the repository", t);
            }
        }
    }

    private Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = parts[0];
        String[] langs = Locale.getISOLanguages();
        for (int i = 0; i < langs.length; ++i) {
            if (!langs[i].equals(lang)) continue;
            lang = null;
            break;
        }
        if (lang != null) {
            parts[0] = Locale.getDefault().getLanguage();
        }
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        String country = parts[1];
        String[] countries = Locale.getISOCountries();
        for (int i = 0; i < countries.length; ++i) {
            if (!countries[i].equals(lang)) continue;
            country = null;
            break;
        }
        if (country != null) {
            parts[1] = Locale.getDefault().getCountry();
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }
}

