/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.i18n.impl.ResourceBundleEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceBundle
extends ResourceBundle {
    private static final Logger log = LoggerFactory.getLogger(JcrResourceBundle.class);
    private static final String JCR_PATH = "jcr:path";
    private static final String PROP_KEY = "sling:key";
    private static final String PROP_VALUE = "sling:message";
    private static final String PROP_BASENAME = "sling:basename";
    private static final String QUERY_BASE = "//element(*,mix:language)[@jcr:language='%s'%s]//element(*,sling:Message)";
    private static final String QUERY_LOAD_FULLY = "//element(*,mix:language)[@jcr:language='%s'%s]//element(*,sling:Message)[@sling:message]/(@sling:key|@sling:message)";
    private static final String QUERY_LOAD_RESOURCE = "//element(*,mix:language)[@jcr:language='%s'%s]//element(*,sling:Message)[@sling:key='%s' or not(@sling:key)]/(@sling:key|@sling:message)";
    private final ResourceResolver resourceResolver;
    private final ConcurrentHashMap<String, Object> resources;
    private boolean fullyLoaded;
    private final Locale locale;
    private final String baseName;
    private String[] searchPath;

    JcrResourceBundle(Locale locale, String baseName, ResourceResolver resourceResolver) {
        this.locale = locale;
        this.baseName = baseName;
        this.resourceResolver = resourceResolver;
        this.resources = new ConcurrentHashMap();
        this.fullyLoaded = false;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadFully();
        return this.resources.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        this.loadFully();
        Enumeration<String> parentKeys = this.parent != null ? this.parent.getKeys() : null;
        return new ResourceBundleEnumeration(this.resources.keySet(), parentKeys);
    }

    @Override
    protected Object handleGetObject(String key) {
        Object value = this.resources.get(key);
        if (value == null && !this.fullyLoaded && (value = this.loadResource(key)) != null) {
            this.resources.put(key, value);
        }
        return value != null ? value : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFully() {
        if (!this.fullyLoaded) {
            JcrResourceBundle jcrResourceBundle = this;
            synchronized (jcrResourceBundle) {
                if (!this.fullyLoaded) {
                    String fullLoadQuery = this.getFullLoadQuery();
                    if (log.isDebugEnabled()) {
                        log.debug("Executing full load query {}", (Object)fullLoadQuery);
                    }
                    Iterator bundles = this.resourceResolver.queryResources(fullLoadQuery, "xpath");
                    String[] path = this.getSearchPath();
                    ArrayList res0 = new ArrayList();
                    for (int i = 0; i < path.length; ++i) {
                        res0.add(new HashMap());
                    }
                    HashMap rest = new HashMap();
                    while (bundles.hasNext()) {
                        Map row = (Map)bundles.next();
                        String jcrPath = (String)row.get(JCR_PATH);
                        String key = (String)row.get(PROP_KEY);
                        if (key == null) {
                            key = ResourceUtil.getName((String)jcrPath);
                        }
                        Map dst = rest;
                        for (int i = 0; i < path.length; ++i) {
                            if (!jcrPath.startsWith(path[i])) continue;
                            dst = (Map)res0.get(i);
                            break;
                        }
                        dst.put(key, row.get(PROP_VALUE));
                    }
                    for (int i = path.length - 1; i >= 0; --i) {
                        rest.putAll((Map)res0.get(i));
                    }
                    this.resources.putAll(rest);
                    this.fullyLoaded = true;
                }
            }
        }
    }

    private Object loadResource(String key) {
        Iterator bundles;
        String resourceQuery = this.getResourceQuery(key);
        if (log.isDebugEnabled()) {
            log.debug("Executing resource query {}", (Object)resourceQuery);
        }
        if ((bundles = this.resourceResolver.queryResources(resourceQuery, "xpath")).hasNext()) {
            String[] path = this.getSearchPath();
            Map currentValue = null;
            int currentWeight = path.length;
            while (bundles.hasNext() && currentWeight > 0) {
                Map resource = (Map)bundles.next();
                String jcrPath = (String)resource.get(JCR_PATH);
                if (resource.get(PROP_KEY) == null && !key.equals(Text.getName((String)jcrPath))) continue;
                for (int i = 0; i < currentWeight; ++i) {
                    if (!jcrPath.startsWith(path[i])) continue;
                    currentWeight = i;
                    currentValue = resource;
                    break;
                }
                if (currentValue != null) continue;
                currentValue = resource;
            }
            if (currentValue != null) {
                return currentValue.get(PROP_VALUE);
            }
        }
        return null;
    }

    private String getFullLoadQuery() {
        return String.format(QUERY_LOAD_FULLY, this.getLocale(), this.getBaseNameTerm());
    }

    private String getResourceQuery(String key) {
        return String.format(QUERY_LOAD_RESOURCE, this.getLocale(), this.getBaseNameTerm(), key.replace("'", "''"));
    }

    private String getBaseNameTerm() {
        if (this.baseName == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(" and @");
        buf.append(PROP_BASENAME);
        if (this.baseName.length() > 0) {
            buf.append("='").append(this.baseName).append('\'');
        }
        return buf.toString();
    }

    private String[] getSearchPath() {
        if (this.searchPath == null) {
            this.searchPath = this.resourceResolver.getSearchPath();
        }
        return this.searchPath;
    }
}

