/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleEnumeration
implements Enumeration<String> {
    private final Set<String> keys;
    private Enumeration<String> parentKeys;
    private Iterator<String> keysIterator;
    private String next;

    public ResourceBundleEnumeration(Set<String> keys, Enumeration<String> parentKeys) {
        this.keys = keys;
        this.parentKeys = parentKeys;
        this.keysIterator = keys.iterator();
        this.next = this.seek();
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public String nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        String result = this.next;
        this.next = this.seek();
        return result;
    }

    private String seek() {
        if (this.keysIterator != null) {
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysIterator = null;
        }
        if (this.parentKeys != null) {
            while (this.parentKeys.hasMoreElements()) {
                String parentKey = this.parentKeys.nextElement();
                if (this.keys.contains(parentKey)) continue;
                return parentKey;
            }
            this.parentKeys = null;
        }
        return null;
    }
}

