/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import org.apache.sling.engine.RequestLog;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

class RequestLogServiceFacade
implements RequestLog {
    private final ServiceTracker requestLogTracker;
    private Object[] loggers;
    private int trackingCount;

    public RequestLogServiceFacade(BundleContext context, String serviceName) {
        String filter = "(&(objectClass=" + RequestLog.class.getName() + ")(" + "requestlog.name" + "=" + serviceName + "))";
        this.requestLogTracker = new ServiceTracker(context, filter, null);
        this.requestLogTracker.open();
        this.trackingCount = -1;
    }

    public void write(String message) {
        Object[] tmpLoggers = this.loggers;
        if (this.trackingCount != this.requestLogTracker.getTrackingCount()) {
            this.loggers = tmpLoggers = this.requestLogTracker.getServices();
        }
        if (tmpLoggers != null) {
            for (int i = 0; i < tmpLoggers.length; ++i) {
                ((RequestLog)tmpLoggers[i]).write(message);
            }
        }
    }

    public void close() {
        this.loggers = null;
        this.trackingCount = -1;
        this.requestLogTracker.close();
    }
}

