/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class RequestLoggerResponse
extends HttpServletResponseWrapper {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final SimpleDateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static AtomicLong requestCounter = new AtomicLong();
    private long requestId = requestCounter.getAndIncrement();
    private long requestStart = System.currentTimeMillis();
    private long requestEnd;
    private LoggerResponseOutputStream out;
    private LoggerResponseWriter writer;
    private int status = 200;
    private Map<String, Cookie> cookies;
    private Map<String, Object> headers;

    RequestLoggerResponse(HttpServletResponse response) {
        super(response);
    }

    void requestEnd() {
        this.requestEnd = System.currentTimeMillis();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            ServletOutputStream sos = super.getOutputStream();
            this.out = new LoggerResponseOutputStream(sos);
        }
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            PrintWriter pw = super.getWriter();
            this.writer = new LoggerResponseWriter(pw);
        }
        return this.writer;
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(location);
        this.status = 302;
    }

    public void sendError(int status) throws IOException {
        super.sendError(status);
        this.status = status;
    }

    public void sendError(int status, String message) throws IOException {
        super.sendError(status, message);
        this.status = status;
    }

    public void setStatus(int status, String message) {
        super.setStatus(status, message);
        this.status = status;
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this.status = status;
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        this.cookies.put(cookie.getName(), cookie);
        super.addCookie(cookie);
    }

    public void addDateHeader(String name, long date) {
        this.registerHeader(name, RequestLoggerResponse.toDateString(date), true);
        super.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.registerHeader(name, value, true);
        super.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.registerHeader(name, String.valueOf(value), true);
        super.addIntHeader(name, value);
    }

    public void setContentLength(int len) {
        this.registerHeader(HEADER_CONTENT_LENGTH, String.valueOf(len), false);
        super.setContentLength(len);
    }

    public void setContentType(String type) {
        this.registerHeader(HEADER_CONTENT_TYPE, type, false);
        super.setContentType(type);
    }

    public void setCharacterEncoding(String charset) {
        if (this.writer == null) {
            super.setCharacterEncoding(charset);
        }
    }

    public void setDateHeader(String name, long date) {
        this.registerHeader(name, RequestLoggerResponse.toDateString(date), false);
        super.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.registerHeader(name, value, false);
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.registerHeader(name, String.valueOf(value), false);
        this.setHeader(name, String.valueOf(value));
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getRequestStart() {
        return this.requestStart;
    }

    public long getRequestEnd() {
        return this.requestEnd;
    }

    public long getRequestDuration() {
        return this.requestEnd - this.requestStart;
    }

    public int getStatus() {
        return this.status;
    }

    public int getCount() {
        if (this.out != null) {
            return this.out.getCount();
        }
        if (this.writer != null) {
            return this.writer.getCount();
        }
        return 0;
    }

    public Cookie getCookie(String name) {
        return this.cookies != null ? this.cookies.get(name) : null;
    }

    public String getHeadersString(String name) {
        Object header;
        name = name.toLowerCase();
        Object object = header = this.headers != null ? this.headers.get(name) : null;
        if (header == null) {
            return null;
        }
        if (header instanceof String) {
            return (String)header;
        }
        StringBuilder headerBuf = new StringBuilder();
        Iterator hi = ((List)header).iterator();
        while (hi.hasNext()) {
            if (headerBuf.length() > 0) {
                headerBuf.append(",");
            }
            headerBuf.append(hi.next());
        }
        return headerBuf.toString();
    }

    private void registerHeader(String name, String value, boolean add) {
        Object current;
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        name = name.toLowerCase();
        Object object = current = add ? this.headers.get(name) : null;
        if (current == null) {
            this.headers.put(name, value);
        } else if (current instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)current);
            list.add(value);
            this.headers.put(name, list);
        } else {
            ((List)current).add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateString(long date) {
        SimpleDateFormat simpleDateFormat = RFC1123_FORMAT;
        synchronized (simpleDateFormat) {
            return RFC1123_FORMAT.format(new Date(date));
        }
    }

    private static class LoggerResponseWriter
    extends PrintWriter {
        private static final int LINE_SEPARATOR_LENGTH = System.getProperty("line.separator").length();
        private int count;

        LoggerResponseWriter(PrintWriter delegatee) {
            super(delegatee);
        }

        public int getCount() {
            return this.count;
        }

        public void write(int c) {
            super.write(c);
            ++this.count;
        }

        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            this.count += len;
        }

        public void write(String s, int off, int len) {
            super.write(s, off, len);
            this.count += len;
        }

        public void println() {
            super.println();
            this.count += LINE_SEPARATOR_LENGTH;
        }
    }

    private static class LoggerResponseOutputStream
    extends ServletOutputStream {
        private ServletOutputStream delegatee;
        private int count;

        LoggerResponseOutputStream(ServletOutputStream delegatee) {
            this.delegatee = delegatee;
        }

        public int getCount() {
            return this.count;
        }

        public void write(int b) throws IOException {
            this.delegatee.write(b);
            ++this.count;
        }

        public void write(byte[] b) throws IOException {
            this.delegatee.write(b);
            this.count += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegatee.write(b, off, len);
            this.count += len;
        }

        public void flush() throws IOException {
            this.delegatee.flush();
        }

        public void close() throws IOException {
            this.delegatee.close();
        }
    }
}

