/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.engine.impl.request.RequestData;

public abstract class AbstractSlingFilterChain
implements FilterChain {
    private Filter[] filters;
    private int current;

    protected AbstractSlingFilterChain(Filter[] filters) {
        this.filters = filters;
        this.current = -1;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ++this.current;
        SlingHttpServletRequest slingRequest = this.toSlingRequest(request);
        SlingHttpServletResponse slingResponse = this.toSlingResponse(response);
        if (this.current < this.filters.length) {
            Filter filter = this.filters[this.current];
            this.trackFilter((ServletRequest)slingRequest, filter);
            filter.doFilter((ServletRequest)slingRequest, (ServletResponse)slingResponse, (FilterChain)this);
        } else {
            this.render(slingRequest, slingResponse);
        }
    }

    protected abstract void render(SlingHttpServletRequest var1, SlingHttpServletResponse var2) throws IOException, ServletException;

    private void trackFilter(ServletRequest request, Filter filter) {
        RequestData data = RequestData.getRequestData(request);
        if (data != null) {
            RequestProgressTracker tracker = data.getRequestProgressTracker();
            tracker.log("Calling filter: {0}", new Object[]{this.filters[this.current].getClass().getName()});
        }
    }

    private SlingHttpServletRequest toSlingRequest(ServletRequest request) {
        if (request instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)request;
        }
        return RequestData.toSlingHttpServletRequest(request);
    }

    private SlingHttpServletResponse toSlingResponse(ServletResponse response) {
        if (response instanceof SlingHttpServletResponse) {
            return (SlingHttpServletResponse)response;
        }
        return RequestData.toSlingHttpServletResponse(response);
    }
}

