/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.sling.engine.impl.parameters.AbstractRequestParameter;
import org.apache.sling.engine.impl.parameters.SlingUnsupportedEncodingException;

public class ContainerRequestParameter
extends AbstractRequestParameter {
    private String value;
    private byte[] content;

    ContainerRequestParameter(String value, String encoding) {
        super(encoding);
        this.value = value;
        this.content = null;
    }

    void setEncoding(String encoding) {
        try {
            this.value = this.getString(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SlingUnsupportedEncodingException(uee);
        }
        super.setEncoding(encoding);
    }

    public byte[] get() {
        if (this.content == null) {
            try {
                this.content = this.getString().getBytes(this.getEncoding());
            }
            catch (Exception e) {
                this.content = this.getString().getBytes();
            }
        }
        return this.content;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.get());
    }

    public String getFileName() {
        return null;
    }

    public long getSize() {
        return this.get().length;
    }

    public String getString() {
        return this.value;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public boolean isFormField() {
        return true;
    }

    public String toString() {
        return this.getString();
    }
}

