/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.output;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.sling.engine.impl.output.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedServletOutputStream
extends ServletOutputStream
implements Buffer {
    private static final Logger log = LoggerFactory.getLogger(BufferedServletOutputStream.class);
    protected OutputStream delegatee;
    private int bufferSize;
    private byte[] buffer;
    private int offset;
    protected boolean closed;

    public BufferedServletOutputStream(OutputStream delegatee, int bufferSize) {
        this.delegatee = delegatee;
        this.offset = 0;
        this.setBufferSize(bufferSize);
    }

    public void setBufferSize(int bufferSize) {
        if (this.offset != 0) {
            throw new IllegalStateException("Buffer not empty");
        }
        if (bufferSize > 0) {
            log.debug("setBufferSize: Creating Buffer of {0} characters", (Object)String.valueOf(bufferSize));
            this.bufferSize = bufferSize;
            this.buffer = new byte[bufferSize];
        } else {
            log.debug("setBufferSize: Disabling Buffering");
            this.bufferSize = -1;
            this.buffer = null;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void resetBuffer() {
        this.offset = 0;
    }

    public void flushBuffer() throws IOException {
        this.assertOpen();
        if (this.buffer != null) {
            if (this.offset > 0) {
                log.debug("flush: Flushing {0} bytes", (Object)String.valueOf(this.offset));
                this.delegatee.write(this.buffer, 0, this.offset);
            } else {
                log.debug("flush: Empty buffer");
            }
        } else {
            log.debug("write: No buffer to flush due to disabled buffering");
        }
        this.offset = 0;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.delegatee.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            this.delegatee.close();
            this.setBufferSize(0);
            this.closed = true;
        }
    }

    public void write(int b) throws IOException {
        this.assertOpen();
        if (this.buffer == null) {
            log.debug("write: Direct writing due to disabled buffering");
            this.delegatee.write(b);
        } else {
            if (this.offset >= this.bufferSize) {
                log.debug("write: Buffer full, flushing first");
                this.flushBuffer();
            }
            this.buffer[this.offset++] = (byte)b;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        if (this.buffer == null) {
            log.debug("write: Direct writing due to disabled buffering");
            this.delegatee.write(b, off, len);
        } else {
            while (this.offset + len - 1 >= this.bufferSize) {
                int space = this.bufferSize - this.offset;
                System.arraycopy(b, off, this.buffer, this.offset, space);
                off += space;
                len -= space;
                log.debug("write: {0} bytes written, flush buffer", (Object)String.valueOf(space));
                this.offset = this.bufferSize;
                this.flushBuffer();
            }
            if (len > 0) {
                log.debug("write: Writing {0} bytes to the buffer", (Object)String.valueOf(len));
                System.arraycopy(b, off, this.buffer, this.offset, len);
                this.offset += len;
            }
        }
    }

    private void assertOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
    }
}

