/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.log.FileRequestLog;
import org.apache.sling.engine.impl.log.RequestLoggerService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class RequestLogger {
    public static final String PROP_REQUEST_LOG_OUTPUT = "request.log.output";
    public static final String PROP_REQUEST_LOG_OUTPUT_TYPE = "request.log.outputtype";
    public static final String PROP_REQUEST_LOG_ENABLED = "request.log.enabled";
    public static final String PROP_ACCESS_LOG_OUTPUT = "access.log.output";
    public static final String PROP_ACCESS_LOG_OUTPUT_TYPE = "access.log.outputtype";
    public static final String PROP_ACCESS_LOG_ENABLED = "access.log.enabled";
    private static final String REQUEST_LOG_ENTRY_FORMAT = "%t [%R] -> %m %U%q %H";
    private static final String REQUEST_LOG_EXIT_FORMAT = "%{end}t [%R] <- %s %{Content-Type}o %Dms";
    private static final String ACCESS_LOG_FORMAT = "%a %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private RequestLoggerService[] requestEntry;
    private RequestLoggerService[] requestExit;
    private RequestLoggerService requestLogEntry;
    private RequestLoggerService requestLogExit;
    private RequestLoggerService accessLog;

    public void logRequestEntry(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (response instanceof SlingHttpServletResponseImpl && this.requestEntry != null) {
            for (int i = 0; i < this.requestEntry.length; ++i) {
                this.requestEntry[i].log(request, (SlingHttpServletResponseImpl)response);
            }
        }
    }

    public void logRequestExit(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (response instanceof SlingHttpServletResponseImpl) {
            SlingHttpServletResponseImpl loggerResponse = (SlingHttpServletResponseImpl)response;
            loggerResponse.requestEnd();
            if (this.requestExit != null) {
                for (int i = 0; i < this.requestExit.length; ++i) {
                    this.requestExit[i].log(request, loggerResponse);
                }
            }
        }
    }

    protected void activate(ComponentContext osgiContext) {
        BundleContext bundleContext = osgiContext.getBundleContext();
        Dictionary props = osgiContext.getProperties();
        FileRequestLog.init(bundleContext.getProperty("sling.home"));
        Object requestLogName = props.get(PROP_REQUEST_LOG_OUTPUT);
        Object requestLogEnabled = props.get(PROP_REQUEST_LOG_ENABLED);
        if (requestLogName != null && requestLogEnabled instanceof Boolean && ((Boolean)requestLogEnabled).booleanValue()) {
            Object requestLogType = props.get(PROP_REQUEST_LOG_OUTPUT_TYPE);
            this.requestLogEntry = this.createRequestLoggerService(bundleContext, true, REQUEST_LOG_ENTRY_FORMAT, requestLogName, requestLogType);
            this.requestLogExit = this.createRequestLoggerService(bundleContext, false, REQUEST_LOG_EXIT_FORMAT, requestLogName, requestLogType);
            this.bindRequestLoggerService(this.requestLogEntry);
            this.bindRequestLoggerService(this.requestLogExit);
        }
        Object accessLogName = props.get(PROP_ACCESS_LOG_OUTPUT);
        Object accessLogEnabled = props.get(PROP_ACCESS_LOG_ENABLED);
        if (accessLogName != null && accessLogEnabled instanceof Boolean && ((Boolean)accessLogEnabled).booleanValue()) {
            Object accessLogType = props.get(PROP_ACCESS_LOG_OUTPUT_TYPE);
            this.accessLog = this.createRequestLoggerService(bundleContext, false, ACCESS_LOG_FORMAT, accessLogName, accessLogType);
            this.bindRequestLoggerService(this.accessLog);
        }
    }

    protected void deactivate(ComponentContext osgiContext) {
        if (this.requestLogEntry != null) {
            this.unbindRequestLoggerService(this.requestLogEntry);
            this.requestLogEntry.shutdown();
            this.requestLogEntry = null;
        }
        if (this.requestLogExit != null) {
            this.unbindRequestLoggerService(this.requestLogExit);
            this.requestLogExit.shutdown();
            this.requestLogExit = null;
        }
        if (this.accessLog != null) {
            this.unbindRequestLoggerService(this.accessLog);
            this.accessLog.shutdown();
            this.accessLog = null;
        }
        FileRequestLog.dispose();
    }

    protected void bindRequestLoggerService(RequestLoggerService requestLoggerService) {
        if (requestLoggerService.isOnEntry()) {
            this.requestEntry = this.addService(this.requestEntry, requestLoggerService);
        } else {
            this.requestExit = this.addService(this.requestExit, requestLoggerService);
        }
    }

    protected void unbindRequestLoggerService(RequestLoggerService requestLoggerService) {
        if (requestLoggerService.isOnEntry()) {
            this.requestEntry = this.removeService(this.requestEntry, requestLoggerService);
        } else {
            this.requestExit = this.removeService(this.requestExit, requestLoggerService);
        }
    }

    private RequestLoggerService createRequestLoggerService(BundleContext bundleContext, boolean onEntry, Object format, Object output, Object outputType) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        config.put("request.log.service.onentry", onEntry ? Boolean.TRUE : Boolean.FALSE);
        config.put("request.log.service.format", format);
        config.put("request.log.service.output", output);
        config.put("request.log.service.outputtype", outputType);
        return new RequestLoggerService(bundleContext, config);
    }

    private RequestLoggerService[] addService(RequestLoggerService[] list, RequestLoggerService requestLoggerService) {
        if (list == null) {
            return new RequestLoggerService[]{requestLoggerService};
        }
        RequestLoggerService[] newList = new RequestLoggerService[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = requestLoggerService;
        return newList;
    }

    private RequestLoggerService[] removeService(RequestLoggerService[] list, RequestLoggerService requestLoggerService) {
        RequestLoggerService[] newList = null;
        for (int i = 0; list != null && i < list.length; ++i) {
            if (list[i] != requestLoggerService) continue;
            newList = new RequestLoggerService[list.length - 1];
            if (i > 0) {
                System.arraycopy(list, 0, newList, 0, i);
            }
            if (i >= list.length - 1) continue;
            System.arraycopy(list, i + 1, newList, 0, newList.length - i);
        }
        return newList != null && newList.length > 0 ? newList : null;
    }
}

