/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHistoryConsolePlugin {
    public static final String LABEL = "requests";
    public static final String INDEX = "index";
    public static final String CLEAR = "clear";
    private static Plugin instance;
    private static ServiceRegistration serviceRegistration;
    public static final int STORED_REQUESTS_COUNT = 20;

    private RequestHistoryConsolePlugin() {
    }

    public static void recordRequest(SlingHttpServletRequest r) {
        if (instance != null) {
            RequestHistoryConsolePlugin.instance.addRequest(r);
        }
    }

    public static void initPlugin(BundleContext context, int maxRequests, List<Pattern> storePatterns) {
        if (instance == null) {
            Plugin tmp = new Plugin(maxRequests, storePatterns);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Web Console Plugin to display information about recent Sling requests");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.pid", ((Object)((Object)tmp)).getClass().getName());
            ((Dictionary)props).put("felix.webconsole.label", LABEL);
            ((Dictionary)props).put("felix.webconsole.title", "Recent requests");
            serviceRegistration = context.registerService("javax.servlet.Servlet", (Object)tmp, props);
            instance = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyPlugin() {
        if (instance != null) {
            try {
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                    serviceRegistration = null;
                }
            }
            finally {
                instance = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestInfoMap
    extends LinkedHashMap<String, RequestInfo> {
        private int maxSize;

        RequestInfoMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RequestInfo> eldest) {
            return this.size() > this.maxSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }

    private static class RequestInfo {
        private static AtomicLong requestCounter = new AtomicLong(0L);
        private final String key = String.valueOf(requestCounter.incrementAndGet());
        private final String method;
        private final String pathInfo;
        private final String user;
        private final RequestProgressTracker tracker;

        RequestInfo(SlingHttpServletRequest request) {
            this.method = request.getMethod();
            this.pathInfo = request.getPathInfo();
            this.user = request.getRemoteUser();
            this.tracker = request.getRequestProgressTracker();
        }

        public String getKey() {
            return this.key;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getUser() {
            return this.user;
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getMethod());
            sb.append(' ');
            String path = this.getPathInfo();
            if (path != null && path.length() > 0) {
                sb.append(ResourceUtil.getName((String)this.getPathInfo()));
            } else {
                sb.append('/');
            }
            return sb.toString();
        }

        public RequestProgressTracker getTracker() {
            return this.tracker;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Plugin
    extends HttpServlet {
        private final RequestInfoMap requests;
        private final List<Pattern> storePatterns;

        Plugin(int maxRequests, List<Pattern> storePatterns) {
            this.requests = maxRequests > 0 ? new RequestInfoMap(maxRequests) : null;
            this.storePatterns = storePatterns;
        }

        public void deactivate() {
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
                serviceRegistration = null;
            }
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRequest(SlingHttpServletRequest r) {
            if (this.requests != null) {
                String requestPath = r.getPathInfo();
                boolean accept = true;
                if (this.storePatterns != null && this.storePatterns.size() > 0) {
                    accept = false;
                    for (Pattern pattern : this.storePatterns) {
                        if (!pattern.matcher(requestPath).matches()) continue;
                        accept = true;
                        break;
                    }
                }
                if (accept) {
                    RequestInfoMap requestInfoMap = this.requests;
                    synchronized (requestInfoMap) {
                        RequestInfo info = new RequestInfo(r);
                        this.requests.put(info.getKey(), info);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            if (this.requests != null) {
                RequestInfoMap requestInfoMap = this.requests;
                synchronized (requestInfoMap) {
                    this.requests.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getLinksTable(String currentRequestIndex) {
            ArrayList<String> links = new ArrayList<String>();
            if (this.requests != null) {
                RequestInfoMap requestInfoMap = this.requests;
                synchronized (requestInfoMap) {
                    for (RequestInfo info : this.requests.values()) {
                        String key = ResponseUtil.escapeXml((String)info.getKey());
                        boolean isCurrent = info.getKey().equals(currentRequestIndex);
                        StringBuilder sb = new StringBuilder();
                        sb.append("<span style='white-space: pre; text-align:right; font-size:80%'>");
                        sb.append(String.format("%1$8s", key));
                        sb.append("</span> ");
                        sb.append("<a href='requests?index=" + key + "'>");
                        if (isCurrent) {
                            sb.append("<b>");
                        }
                        sb.append(ResponseUtil.escapeXml((String)info.getLabel()));
                        if (isCurrent) {
                            sb.append("</b>");
                        }
                        sb.append("</a> ");
                        links.add(sb.toString());
                    }
                }
            }
            int nCols = 5;
            while (links.size() % 5 != 0) {
                links.add("&nbsp;");
            }
            StringBuilder tbl = new StringBuilder();
            tbl.append("<table class='nicetable ui-widget'>\n<tr>\n");
            if (links.isEmpty()) {
                tbl.append("No Requests recorded");
            } else {
                int i = 0;
                for (String str : links) {
                    if (i++ % 5 == 0) {
                        tbl.append("</tr>\n<tr>\n");
                    }
                    tbl.append("<td>");
                    tbl.append(str);
                    tbl.append("</td>\n");
                }
            }
            tbl.append("</tr>\n");
            tbl.append("</table>\n");
            return tbl.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            RequestInfo info = null;
            String key = req.getParameter(RequestHistoryConsolePlugin.INDEX);
            if (key != null && this.requests != null) {
                RequestInfoMap requestInfoMap = this.requests;
                synchronized (requestInfoMap) {
                    info = (RequestInfo)this.requests.get(key);
                }
            }
            PrintWriter pw = resp.getWriter();
            if (this.requests != null) {
                pw.println("<p class='statline ui-state-highlight'>Recorded " + this.requests.size() + " requests (max: " + this.requests.getMaxSize() + ")</p>");
            } else {
                pw.println("<p class='statline ui-state-highlight'>Request Recording disabled</p>");
            }
            pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
            pw.println("<span style='float: left; margin-left: 1em'>Recent Requests</span>");
            pw.println("<form method='POST'><input type='hidden' name='clear' value='clear'><input type='submit' value='Clear' class='ui-state-default ui-corner-all'></form>");
            pw.println("</div>");
            pw.println(this.getLinksTable(key));
            pw.println("<br/>");
            if (info != null) {
                pw.println("<table class='nicetable ui-widget'>");
                pw.println("<thead>");
                pw.println("<tr>");
                pw.printf("<th class='ui-widget-header'>Request %s (%s %s) by %s - RequestProgressTracker Info</th>%n", key, ResponseUtil.escapeXml((String)info.getMethod()), ResponseUtil.escapeXml((String)info.getPathInfo()), ResponseUtil.escapeXml((String)info.getUser()));
                pw.println("</tr>");
                pw.println("</thead>");
                pw.println("<tbody>");
                pw.println("<tr><td>");
                Iterator it = info.getTracker().getMessages();
                pw.print("<pre>");
                while (it.hasNext()) {
                    pw.print(ResponseUtil.escapeXml((String)((String)it.next())));
                }
                pw.println("</pre></td></tr>");
                pw.println("</tbody></table>");
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            if (req.getParameter(RequestHistoryConsolePlugin.CLEAR) != null) {
                this.clear();
                resp.sendRedirect(req.getRequestURI());
            }
        }
    }
}

