/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlingHttpContext
implements HttpContext {
    private static final Logger log = LoggerFactory.getLogger(SlingHttpContext.class);
    private MimeTypeService mimeTypeService;
    private AuthenticationSupport authenticationSupport;

    SlingHttpContext() {
    }

    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        if (this.authenticationSupport == authenticationSupport) {
            this.authenticationSupport = null;
        }
    }

    public String getMimeType(String name) {
        MimeTypeService mtservice = this.mimeTypeService;
        if (mtservice != null) {
            return mtservice.getMimeType(name);
        }
        log.debug("getMimeType: MimeTypeService not available, cannot resolve mime type for {}", (Object)name);
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthenticationSupport authenticator = this.authenticationSupport;
        if (authenticator != null) {
            request = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getParameter(String name) {
                    return this.getParameterSupport().getParameter(name);
                }

                public Map<String, String[]> getParameterMap() {
                    return this.getParameterSupport().getParameterMap();
                }

                public Enumeration<String> getParameterNames() {
                    return this.getParameterSupport().getParameterNames();
                }

                public String[] getParameterValues(String name) {
                    return this.getParameterSupport().getParameterValues(name);
                }

                private ParameterSupport getParameterSupport() {
                    return ParameterSupport.getInstance(this.getRequest());
                }
            };
            return authenticator.handleSecurity(request, response);
        }
        log.error("handleSecurity: AuthenticationSupport service missing. Cannot authenticate request.");
        log.error("handleSecurity: Possible reason is missing Repository service. Check AuthenticationSupport dependencies.");
        response.sendError(503, "AuthenticationSupport service missing. Cannot authenticate request.");
        response.flushBuffer();
        return false;
    }
}

