/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.apache.sling.engine.impl.output.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedPrintWriter
extends PrintWriter
implements Buffer {
    private static final Logger log = LoggerFactory.getLogger(BufferedPrintWriter.class);
    private static final String lineSeparator = System.getProperty("line.separator");
    private int bufferSize;
    private char[] buffer;
    private int offset = 0;
    protected boolean trouble;
    protected boolean closed;
    protected boolean loggedNoBuffering = false;

    public BufferedPrintWriter(PrintWriter servletWriter, int bufferSize) {
        super((Writer)servletWriter, false);
        this.setBufferSize(bufferSize);
    }

    BufferedPrintWriter(ServletResponse response) throws IOException {
        this(response.getWriter(), response.getBufferSize());
    }

    public void setBufferSize(int bufferSize) {
        if (this.offset != 0) {
            throw new IllegalStateException("Buffer not empty");
        }
        if (bufferSize > 0) {
            log.debug("setBufferSize: Creating Buffer of {0} characters", (Object)String.valueOf(bufferSize));
            this.bufferSize = bufferSize;
            this.buffer = new char[bufferSize];
        } else {
            log.debug("setBufferSize: Disabling Buffering");
            this.bufferSize = -1;
            this.buffer = null;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void resetBuffer() {
        log.debug("resetBuffer");
        this.offset = 0;
    }

    public void flushBuffer() {
        if (this.isClosed()) {
            log.info("flush: PrintWriter already closed. No Flushing");
            this.setError();
            return;
        }
        if (this.buffer != null) {
            if (this.offset > 0) {
                log.debug("flush: Flushing {0} characters", (Object)String.valueOf(this.offset));
                super.write(this.buffer, 0, this.offset);
            } else {
                log.debug("flush: Empty buffer");
            }
        } else {
            log.debug("write: No buffer to flush due to disabled buffering");
        }
        this.offset = 0;
    }

    public boolean checkError() {
        return this.trouble || super.checkError();
    }

    protected void setError() {
        this.trouble = true;
        super.setError();
    }

    public void flush() {
        this.flushBuffer();
        if (!this.isClosed()) {
            super.flush();
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this.flushBuffer();
            super.close();
            this.setBufferSize(0);
            this.closed = true;
        }
    }

    public void write(int c) {
        if (this.isClosed()) {
            log.info("write: PrintWriter already closed. No Writing");
            this.setError();
            return;
        }
        if (this.buffer == null) {
            if (!this.loggedNoBuffering) {
                log.debug("write: Direct writing due to disabled buffering");
                this.loggedNoBuffering = true;
            }
            super.write(c);
        } else {
            if (this.offset >= this.bufferSize) {
                log.debug("write: Buffer full, flushing first");
                this.flushBuffer();
            }
            this.buffer[this.offset++] = (char)c;
        }
    }

    public void write(char[] buf, int off, int len) {
        if (this.isClosed()) {
            log.info("write: PrintWriter already closed. No Writing");
            this.setError();
            return;
        }
        if (this.buffer == null) {
            if (!this.loggedNoBuffering) {
                log.debug("write: Direct writing due to disabled buffering");
                this.loggedNoBuffering = true;
            }
            super.write(buf, off, len);
        } else {
            while (this.offset + len - 1 >= this.bufferSize) {
                int space = this.bufferSize - this.offset;
                System.arraycopy(buf, off, this.buffer, this.offset, space);
                off += space;
                len -= space;
                log.debug("write: {0} characters written, flush buffer", (Object)String.valueOf(space));
                this.offset = this.bufferSize;
                this.flushBuffer();
            }
            if (len > 0) {
                log.debug("write: Writing {0} characters to the buffer", (Object)String.valueOf(len));
                System.arraycopy(buf, off, this.buffer, this.offset, len);
                this.offset += len;
            }
        }
    }

    public void write(String s, int off, int len) {
        if (this.isClosed()) {
            log.info("write: PrintWriter already closed. No Writing");
            this.setError();
            return;
        }
        if (this.buffer == null) {
            if (!this.loggedNoBuffering) {
                log.debug("write: Direct writing due to disabled buffering");
                this.loggedNoBuffering = true;
            }
            super.write(s, off, len);
        } else {
            while (this.offset + len - 1 >= this.bufferSize) {
                int space = this.bufferSize - this.offset;
                s.getChars(off, off + space, this.buffer, this.offset);
                off += space;
                len -= space;
                log.debug("write: {0} characters written, flush buffer", (Object)String.valueOf(space));
                this.offset = this.bufferSize;
                this.flushBuffer();
            }
            if (len > 0) {
                log.debug("write: Writing {0} characters to the buffer", (Object)String.valueOf(len));
                s.getChars(off, off + len, this.buffer, this.offset);
                this.offset += len;
            }
        }
    }

    public void println() {
        this.write(lineSeparator);
    }

    private boolean isClosed() {
        return this.closed;
    }
}

