/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.TooManyCallsException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.engine.impl.SlingHttpServletRequestImpl;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.apache.sling.engine.impl.adapter.SlingServletRequestAdapter;
import org.apache.sling.engine.impl.adapter.SlingServletResponseAdapter;
import org.apache.sling.engine.impl.output.BufferProvider;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.apache.sling.engine.impl.request.SlingRequestProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestData
implements BufferProvider {
    private final Logger log = LoggerFactory.getLogger(RequestData.class);
    public static final int DEFAULT_MAX_INCLUSION_COUNTER = 50;
    public static final int DEFAULT_MAX_CALL_COUNTER = 1000;
    private static int maxInclusionCounter = 50;
    private static int maxCallCounter = 1000;
    private final SlingMainServlet slingMainServlet;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private SlingHttpServletRequest slingRequest;
    private SlingHttpServletResponse slingResponse;
    private ParameterSupport parameterSupport;
    private ResourceResolver resourceResolver;
    private RequestProgressTracker requestProgressTracker;
    private ContentData currentContentData;
    private LinkedList<ContentData> contentDataStack;
    private int servletCallCounter;
    private String activeServletName;

    public static void setMaxCallCounter(int maxCallCounter) {
        RequestData.maxCallCounter = maxCallCounter;
    }

    public static int getMaxCallCounter() {
        return maxCallCounter;
    }

    public static void setMaxIncludeCounter(int maxInclusionCounter) {
        RequestData.maxInclusionCounter = maxInclusionCounter;
    }

    public static int getMaxIncludeCounter() {
        return maxInclusionCounter;
    }

    public RequestData(SlingMainServlet slingMainServlet, HttpServletRequest request, HttpServletResponse response) {
        this.slingMainServlet = slingMainServlet;
        this.servletRequest = request;
        this.servletResponse = response;
        this.slingRequest = new SlingHttpServletRequestImpl(this, this.servletRequest);
        this.slingResponse = new SlingHttpServletResponseImpl(this, this.servletResponse);
        this.requestProgressTracker = new SlingRequestProgressTracker();
        this.requestProgressTracker.log("Method=" + this.slingRequest.getMethod() + ", PathInfo=" + this.slingRequest.getPathInfo());
    }

    public Resource initResource(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.requestProgressTracker.startTimer("ResourceResolution");
        SlingHttpServletRequest request = this.getSlingRequest();
        Resource resource = resourceResolver.resolve((HttpServletRequest)request, request.getPathInfo());
        this.requestProgressTracker.logTimer("ResourceResolution", "URI={0} resolves to Resource={1}", new Object[]{this.getServletRequest().getRequestURI(), resource});
        return resource;
    }

    public void initServlet(Resource resource) {
        SlingRequestPathInfo requestPathInfo = new SlingRequestPathInfo(resource);
        ContentData contentData = this.pushContent(resource, requestPathInfo);
        this.requestProgressTracker.log("Resource Path Info: {0}", new Object[]{requestPathInfo});
        ServletResolver sr = this.slingMainServlet.getServletResolver();
        if (sr != null) {
            this.requestProgressTracker.startTimer("ServletResolution");
            Servlet servlet = sr.resolveServlet(this.slingRequest);
            this.requestProgressTracker.logTimer("ServletResolution", "URI={0} handled by Servlet={1}", new Object[]{this.getServletRequest().getRequestURI(), RequestUtil.getServletName((Servlet)servlet)});
            contentData.setServlet(servlet);
        } else {
            this.log.warn("init(): No ServletResolver available");
        }
    }

    public void dispose() {
        this.servletRequest.removeAttribute("org.apache.sling.api.include.resource");
        this.servletRequest.removeAttribute("org.apache.sling.api.include.servlet");
        if (this.contentDataStack != null) {
            while (!this.contentDataStack.isEmpty()) {
                ContentData cd = this.contentDataStack.removeLast();
                cd.dispose();
            }
        }
        if (this.currentContentData != null) {
            this.currentContentData.dispose();
        }
        this.contentDataStack = null;
        this.currentContentData = null;
        this.servletRequest = null;
        this.servletResponse = null;
        this.resourceResolver = null;
    }

    public SlingMainServlet getSlingMainServlet() {
        return this.slingMainServlet;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public SlingHttpServletRequest getSlingRequest() {
        return this.slingRequest;
    }

    public SlingHttpServletResponse getSlingResponse() {
        return this.slingResponse;
    }

    public static SlingHttpServletRequest unwrap(ServletRequest request) {
        if (request instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)request;
        }
        while (request instanceof ServletRequestWrapper) {
            if (!((request = ((ServletRequestWrapper)request).getRequest()) instanceof SlingHttpServletRequest)) continue;
            return (SlingHttpServletRequest)request;
        }
        throw new IllegalArgumentException("ServletRequest not wrapping SlingHttpServletRequest");
    }

    public static SlingHttpServletRequestImpl unwrap(SlingHttpServletRequest request) {
        while (request instanceof SlingHttpServletRequestWrapper) {
            request = ((SlingHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof SlingHttpServletRequestImpl) {
            return (SlingHttpServletRequestImpl)request;
        }
        throw new IllegalArgumentException("SlingHttpServletRequest not of correct type");
    }

    public static SlingHttpServletResponse unwrap(ServletResponse response) {
        if (response instanceof SlingHttpServletResponse) {
            return (SlingHttpServletResponse)response;
        }
        while (response instanceof ServletResponseWrapper) {
            if (!((response = ((ServletResponseWrapper)response).getResponse()) instanceof SlingHttpServletResponse)) continue;
            return (SlingHttpServletResponse)response;
        }
        throw new IllegalArgumentException("ServletResponse not wrapping SlingHttpServletResponse");
    }

    public static SlingHttpServletResponseImpl unwrap(SlingHttpServletResponse response) {
        while (response instanceof SlingHttpServletResponseWrapper) {
            response = ((SlingHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof SlingHttpServletResponseImpl) {
            return (SlingHttpServletResponseImpl)response;
        }
        throw new IllegalArgumentException("SlingHttpServletResponse not of correct type");
    }

    public static RequestData getRequestData(ServletRequest request) {
        return RequestData.unwrap(RequestData.unwrap(request)).getRequestData();
    }

    public static RequestData getRequestData(SlingHttpServletRequest request) {
        return RequestData.unwrap(request).getRequestData();
    }

    public static SlingHttpServletRequest toSlingHttpServletRequest(ServletRequest request) {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData.unwrap(cRequest);
        if (cRequest == request) {
            return cRequest;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HTTP request");
        }
        return new SlingServletRequestAdapter(cRequest, (HttpServletRequest)request);
    }

    public static SlingHttpServletResponse toSlingHttpServletResponse(ServletResponse response) {
        SlingHttpServletResponse cResponse = RequestData.unwrap(response);
        RequestData.unwrap(cResponse);
        if (cResponse == response) {
            return cResponse;
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Response is not an HTTP response");
        }
        return new SlingServletResponseAdapter(cResponse, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        RequestData requestData = RequestData.getRequestData(request);
        Servlet servlet = requestData.getContentData().getServlet();
        if (servlet == null) {
            response.sendError(404, "No Servlet to handle request");
        } else {
            String name = RequestUtil.getServletName((Servlet)servlet);
            if (requestData.servletCallCounter >= maxCallCounter) {
                throw new TooManyCallsException(name);
            }
            Object oldValue = request.getAttribute("sling.core.current.servletName");
            request.setAttribute("sling.core.current.servletName", (Object)name);
            String timerName = name + "#" + requestData.servletCallCounter;
            ++requestData.servletCallCounter;
            requestData.getRequestProgressTracker().startTimer(timerName);
            try {
                String callerServlet = requestData.setActiveServletName(name);
                servlet.service((ServletRequest)request, (ServletResponse)response);
                requestData.setActiveServletName(callerServlet);
            }
            finally {
                request.setAttribute("sling.core.current.servletName", oldValue);
                requestData.getRequestProgressTracker().logTimer(timerName);
            }
        }
    }

    public ContentData pushContent(Resource resource, RequestPathInfo requestPathInfo) {
        BufferProvider parent;
        if (this.currentContentData != null) {
            if (this.contentDataStack == null) {
                this.contentDataStack = new LinkedList();
            } else if (this.contentDataStack.size() >= maxInclusionCounter) {
                throw new RecursionTooDeepException(requestPathInfo.getResourcePath());
            }
            this.contentDataStack.add(this.currentContentData);
            parent = this.currentContentData;
        } else {
            parent = this;
        }
        this.currentContentData = new ContentData(resource, requestPathInfo, parent);
        return this.currentContentData;
    }

    public ContentData popContent() {
        if (this.currentContentData != null) {
            this.currentContentData.dispose();
        }
        this.currentContentData = this.contentDataStack != null && !this.contentDataStack.isEmpty() ? this.contentDataStack.removeLast() : null;
        return this.currentContentData;
    }

    public ContentData getContentData() {
        return this.currentContentData;
    }

    public boolean isContentIncluded() {
        return this.contentDataStack != null && !this.contentDataStack.isEmpty();
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.requestProgressTracker;
    }

    public String setActiveServletName(String servletName) {
        String old = this.activeServletName;
        this.activeServletName = servletName;
        return old;
    }

    public String getActiveServletName() {
        return this.activeServletName;
    }

    public AdapterManager getAdapterManager() {
        return this.slingMainServlet.getAdapterManager();
    }

    public BufferProvider getBufferProvider() {
        return this.currentContentData != null ? this.currentContentData : this;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getServletResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.getServletResponse().getWriter();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getReader();
    }

    public ParameterSupport getParameterSupport() {
        if (this.parameterSupport == null) {
            this.parameterSupport = ParameterSupport.getInstance((ServletRequest)this.getServletRequest());
        }
        return this.parameterSupport;
    }
}

