/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.apache.sling.engine.impl.request.SlingRequestDispatcher;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingServletContext
implements ServletContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SlingMainServlet slingMainServlet;
    private final ServiceRegistration registration;

    public SlingServletContext(SlingMainServlet slingMainServlet) {
        this.slingMainServlet = slingMainServlet;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.getClass().getName());
        ((Dictionary)props).put("service.description", "Sling ServletContext");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = slingMainServlet.getBundleContext().registerService(ServletContext.class.getName(), (Object)this, props);
    }

    public void dispose() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public String getServletContextName() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getServletContextName();
        }
        return null;
    }

    public String getContextPath() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            try {
                return (String)delegatee.getClass().getMethod("getContextPath", null).invoke((Object)this.getServletContext(), (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String getInitParameter(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameter(name);
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameterNames();
        }
        return null;
    }

    public Object getAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttribute(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttributeNames();
        }
        return Collections.enumeration(Collections.emptyList());
    }

    public void removeAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object object) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.setAttribute(name, object);
        }
    }

    public String getServerInfo() {
        return this.slingMainServlet.getServerInfo();
    }

    public int getMajorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMajorVersion();
        }
        return 2;
    }

    public int getMinorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMinorVersion();
        }
        return 4;
    }

    public String getMimeType(String file) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMimeType(file);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            this.log.error("getRequestDispatcher: No path, cannot create request dispatcher");
            return null;
        }
        return new SlingRequestDispatcher(path, null);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getNamedDispatcher(name);
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResource(path);
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourceAsStream(path);
        }
        return null;
    }

    public Set<String> getResourcePaths(String parentPath) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourcePaths(parentPath);
        }
        return null;
    }

    public String getRealPath(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getRealPath(path);
        }
        return null;
    }

    public void log(String message, Throwable throwable) {
        this.log.error(message, throwable);
    }

    public void log(String message) {
        this.log.info(message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public ServletContext getContext(String uripath) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getContext(uripath);
        }
        return null;
    }

    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    @Deprecated
    public Enumeration<?> getServletNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    @Deprecated
    public Enumeration<?> getServlets() {
        return Collections.enumeration(Collections.emptyList());
    }

    private ServletContext getServletContext() {
        return this.slingMainServlet.getServletContext();
    }
}

