/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebConsoleConfigPrinter
implements ConfigurationPrinter {
    private final SlingFilterChainHelper requestFilterChain;
    private final SlingFilterChainHelper innerFilterChain;

    public WebConsoleConfigPrinter(SlingFilterChainHelper requestFilterChain, SlingFilterChainHelper innerFilterChain) {
        this.requestFilterChain = requestFilterChain;
        this.innerFilterChain = innerFilterChain;
    }

    public static Object register(BundleContext bundleContext, SlingFilterChainHelper requestFilterChain, SlingFilterChainHelper innerFilterChain) {
        Registration reg = new Registration();
        WebConsoleConfigPrinter filterPrinter = new WebConsoleConfigPrinter(requestFilterChain, innerFilterChain);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Servlet Filter Configuration Printer");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        reg.filterPlugin = bundleContext.registerService(ConfigurationPrinter.class.getName(), (Object)filterPrinter, serviceProps);
        return reg;
    }

    public static void unregister(Object reg) {
        if (reg instanceof Registration) {
            Registration registration = (Registration)reg;
            if (registration.filterPlugin != null) {
                registration.filterPlugin.unregister();
                registration.filterPlugin = null;
            }
        }
    }

    public String getTitle() {
        return "Servlet Filter";
    }

    private void printFilterChain(PrintWriter pw, SlingFilterChainHelper.FilterListEntry[] entries) {
        if (entries == null) {
            pw.println("---");
        } else {
            for (SlingFilterChainHelper.FilterListEntry entry : entries) {
                pw.print(entry.getOrder());
                pw.print(" : ");
                pw.print(entry.getFilter().getClass());
                pw.print(" (");
                pw.print(entry.getFitlerId());
                pw.println(")");
            }
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        pw.println();
        pw.println("Request Filters:");
        this.printFilterChain(pw, this.requestFilterChain.getFilterListEntries());
        pw.println();
        pw.println("Component Filters:");
        this.printFilterChain(pw, this.innerFilterChain.getFilterListEntries());
    }

    private static final class Registration {
        public ServiceRegistration filterPlugin;

        private Registration() {
        }
    }
}

