/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.web;

import java.util.SortedMap;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.api.graph.Graphs;
import org.apache.sirona.repositories.Repositories;
import org.apache.sirona.repositories.Repository;

public class WebEndpoints {
    @Regex
    public Template home() {
        return new Template("web/web.vm");
    }

    @Regex(value="/sessions/([0-9]*)/([0-9]*)")
    public String sessions(long start, long end) {
        StringBuilder builder = new StringBuilder("[");
        for (Role gauge : Repositories.findByPrefixAndUnit((String)"sessions-", (Unit)Unit.UNARY)) {
            builder.append("{ \"data\": ").append(Graphs.toJson((SortedMap)Repository.INSTANCE.getGaugeValues(start, end, gauge))).append(", \"label\": \"").append(gauge.getName()).append("\", \"color\": \"#317eac\" }").append(",");
        }
        int length = builder.length();
        if (length > 1) {
            return builder.toString().substring(0, length - 1) + "]";
        }
        return builder.append("]").toString();
    }
}

