/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.handler;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.template.Templates;

public class TemplateHelper {
    private static final String EMPTY_STRING = "";
    private final PrintWriter writer;
    private final Map<String, ?> params;

    public TemplateHelper(PrintWriter writer, Map<String, ?> params) {
        this.writer = writer;
        this.params = params;
    }

    public void renderHtml(String template) {
        this.renderHtml(template, Collections.emptyMap());
    }

    public void renderHtml(String template, Map<String, ? extends Object> userParams) {
        Templates.htmlRender(this.writer, template, new MapBuilder().set((Map)Map.class.cast(this.params)).set((Map)Map.class.cast(userParams)).build());
    }

    public void renderPlain(String template, Map<String, ?> params) {
        Templates.render(this.writer, template, params);
    }

    public void renderPlain(String template) {
        this.renderPlain(template, Collections.emptyMap());
    }

    public void write(String message) {
        this.writer.write(message);
    }

    public static String nullProtection(String value) {
        if (value == null) {
            return EMPTY_STRING;
        }
        return value;
    }
}

