/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.plugin.hazelcast.gui;

import java.util.Collection;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.api.graph.Graphs;
import org.apache.sirona.repositories.Repositories;
import org.apache.sirona.repositories.Repository;

public class HazelcastEndpoints {
    @Regex
    public Template home() {
        return new Template("hazelcast/home.vm");
    }

    @Regex(value="/partitions")
    public Template partitions() {
        return HazelcastEndpoints.hazelcastTemplate("Partition number", "partitions");
    }

    @Regex(value="/members")
    public Template members() {
        return HazelcastEndpoints.hazelcastTemplate("Members number", "members");
    }

    @Regex(value="/([^/]*)/([0-9]*)/([0-9]*)")
    public String jsonDetail(String role, long start, long end) {
        return Graphs.generateReport((String)role, (Role)Repository.INSTANCE.findGaugeRole(role), (long)start, (long)end);
    }

    private static Template hazelcastTemplate(String title, String name) {
        return new Template("hazelcast/gauges.vm", new MapBuilder().set((Object)"title", (Object)title).set((Object)"members", (Object)Repositories.names((Collection)Repositories.findByPrefixAndUnit((String)("hazelcast-" + name + "-"), (Unit)Unit.UNARY))).build());
    }
}

