/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.boomerang.parser;

import java.util.Map;
import org.apache.sirona.boomerang.parser.BoomerangData;

public class QueryParser {
    public static BoomerangData parse(Map<String, String> params) {
        String lat;
        String bw;
        String tDone;
        String version;
        BoomerangData data = new BoomerangData(params);
        String url = params.get("u");
        if (url != null) {
            data.setUrl(url);
        }
        if ((version = params.get("v")) != null) {
            data.setVersion(version);
        }
        if ((tDone = params.get("t_done")) != null && !tDone.isEmpty()) {
            data.setTDone(QueryParser.parseLong(tDone));
        }
        if ((bw = params.get("bw")) != null && !bw.isEmpty()) {
            data.setBandwidth(QueryParser.parseLong(bw));
        }
        if ((lat = params.get("lat")) != null && !lat.isEmpty()) {
            data.setLatency(QueryParser.parseLong(lat));
        }
        return data;
    }

    private static Long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nbe) {
            return null;
        }
    }

    private QueryParser() {
    }
}

